/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputBinaryFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.NoOpSourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.facade.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.util.TextOutput;
import org.jetbrains.kotlin.js.util.TextOutputImpl;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "Fail", "Success", "js.translator"})
public abstract class TranslationResult {
    @NotNull
    private final Diagnostics diagnostics;

    @NotNull
    public final Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    protected TranslationResult(@NotNull Diagnostics diagnostics2) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostics2, (String)"diagnostics");
        this.diagnostics = diagnostics2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Fail;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "js.translator"})
    public static final class Fail
    extends TranslationResult {
        public Fail(@NotNull Diagnostics diagnostics2) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostics2, (String)"diagnostics");
            super(diagnostics2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0018\u001a\u00020\fJ\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010#\u001a\u0004\u0018\u00010!J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Success;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "importedModules", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/js/config/JsConfig;Ljava/util/List;Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getProgram", "()Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "getCode", "", "output", "Lorg/jetbrains/kotlin/js/util/TextOutput;", "sourceLocationConsumer", "Lorg/jetbrains/kotlin/js/backend/SourceLocationConsumer;", "getOutputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "outputFile", "Ljava/io/File;", "outputPrefixFile", "outputPostfixFile", "kjsmFileForPackage", "Lorg/jetbrains/kotlin/backend/common/output/SimpleOutputBinaryFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "bytes", "", "js.translator"})
    public static final class Success
    extends TranslationResult {
        private final JsConfig config;
        private final List<KtFile> files;
        @NotNull
        private final JsProgram program;
        private final List<String> importedModules;
        @NotNull
        private final ModuleDescriptor moduleDescriptor;
        @NotNull
        private final BindingContext bindingContext;

        @NotNull
        public final String getCode() {
            TextOutputImpl output = new TextOutputImpl();
            this.getCode(output, null);
            String string = output.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OutputFileCollection getOutputFiles(@NotNull File outputFile, @Nullable File outputPrefixFile, @Nullable File outputPostfixFile) {
            Object virtualFile;
            ModuleKind it;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object object;
            Object prefix;
            SourceMapBuilderConsumer sourceMapBuilderConsumer;
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            TextOutputImpl output = new TextOutputImpl();
            SourceMap3Builder sourceMapBuilder = new SourceMap3Builder(outputFile, output, this.config.getSourceMapPrefix());
            if (this.config.getConfiguration().getBoolean(JSConfigurationKeys.SOURCE_MAP)) {
                SourceMapSourceEmbedding sourceMapSourceEmbedding = this.config.getSourceMapContentEmbedding();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sourceMapSourceEmbedding), (String)"config.sourceMapContentEmbedding");
                SourceMapSourceEmbedding sourceMapContentEmbedding = sourceMapSourceEmbedding;
                SourceFilePathResolver sourceFilePathResolver = SourceFilePathResolver.create(this.config);
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFilePathResolver, (String)"SourceFilePathResolver.create(config)");
                SourceFilePathResolver pathResolver = sourceFilePathResolver;
                sourceMapBuilderConsumer = new SourceMapBuilderConsumer(new File("."), sourceMapBuilder, pathResolver, sourceMapContentEmbedding == SourceMapSourceEmbedding.ALWAYS, sourceMapContentEmbedding != SourceMapSourceEmbedding.NEVER);
            } else {
                sourceMapBuilderConsumer = null;
            }
            SourceMapBuilderConsumer sourceMapBuilderConsumer2 = sourceMapBuilderConsumer;
            this.getCode(output, sourceMapBuilderConsumer2);
            if (sourceMapBuilderConsumer2 != null) {
                sourceMapBuilder.addLink();
            }
            String string = output.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.toString()");
            String code = string;
            Object object2 = outputPrefixFile;
            if (object2 == null || (object2 = FilesKt.readText$default((File)object2, null, (int)1, null)) == null) {
                object2 = prefix = "";
            }
            if ((object = outputPostfixFile) == null || (object = FilesKt.readText$default((File)object, null, (int)1, null)) == null) {
                object = "";
            }
            Object postfix = object;
            Iterable iterable = $receiver$iv = (Iterable)this.files;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                File file;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                PsiFile psiFile = it.getOriginalFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"it.originalFile");
                virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null) {
                    file = new File(it.getName());
                } else {
                    File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    file = file2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"VfsUtilCore.virtualToIoFile(virtualFile)");
                }
                File file3 = file;
                collection.add(file3);
            }
            List sourceFiles = (List)destination$iv$iv;
            String string2 = outputFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"outputFile.name");
            SimpleOutputFile jsFile = new SimpleOutputFile(sourceFiles, string2, (String)prefix + code + (String)postfix);
            ArrayList outputFiles = CollectionsKt.arrayListOf((Object[])new OutputFile[]{jsFile});
            if (this.config.getConfiguration().getBoolean(JSConfigurationKeys.META_INFO)) {
                JsMetadataVersion jsMetadataVersion;
                Object item$iv$iv;
                String string3 = outputFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"outputFile.name");
                String metaFileName = KotlinJavascriptMetadataUtils.INSTANCE.replaceSuffix(string3);
                String string4 = this.config.getModuleId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"config.moduleId");
                ModuleKind moduleKind = this.config.getModuleKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)moduleKind), (String)"config.moduleKind");
                item$iv$iv = this.importedModules;
                it = moduleKind;
                virtualFile = this.moduleDescriptor;
                JsModuleDescriptor<VirtualFile> moduleDescription = new JsModuleDescriptor<VirtualFile>(string4, it, (List<String>)item$iv$iv, (VirtualFile)virtualFile);
                CompilerConfiguration compilerConfiguration = this.config.getConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"config.configuration");
                LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
                BinaryVersion binaryVersion = this.config.getConfiguration().get(CommonConfigurationKeys.METADATA_VERSION);
                if (!(binaryVersion instanceof JsMetadataVersion)) {
                    binaryVersion = null;
                }
                if ((jsMetadataVersion = (JsMetadataVersion)binaryVersion) == null) {
                    jsMetadataVersion = JsMetadataVersion.INSTANCE;
                }
                KotlinJavascriptSerializationUtil.SerializedMetadata serializedMetadata = KotlinJavascriptSerializationUtil.INSTANCE.serializeMetadata(this.bindingContext, moduleDescription, languageVersionSettings, jsMetadataVersion);
                String metaFileContent = serializedMetadata.asString();
                ArrayList sourceFilesForMetaFile = new ArrayList(sourceFiles);
                SimpleOutputFile jsMetaFile = new SimpleOutputFile(sourceFilesForMetaFile, metaFileName, metaFileContent);
                outputFiles.add(jsMetaFile);
                for (KotlinJavascriptSerializationUtil.SerializedMetadata.SerializedPackage serializedPackage : serializedMetadata.serializedPackages()) {
                    outputFiles.add(this.kjsmFileForPackage(serializedPackage.getFqName(), serializedPackage.getBytes()));
                }
            }
            if (sourceMapBuilderConsumer2 != null) {
                sourceMapBuilder.skipLinesAtBeginning(StringUtil.getLineBreakCount((CharSequence)((CharSequence)prefix)));
                File file = sourceMapBuilder.getOutFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sourceMapBuilder.outFile");
                String string5 = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceMapBuilder.outFile.name");
                String string6 = sourceMapBuilder.build();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"sourceMapBuilder.build()");
                SimpleOutputFile sourceMapFile = new SimpleOutputFile(sourceFiles, string5, string6);
                outputFiles.add(sourceMapFile);
                sourceMapBuilder.addLink();
            }
            return new SimpleOutputFileCollection(outputFiles);
        }

        /*
         * WARNING - void declaration
         */
        private final SimpleOutputBinaryFile kjsmFileForPackage(FqName packageFqName, byte[] bytes) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Collection collection = (Collection)this.bindingContext.get(BindingContext.PACKAGE_TO_FILES, packageFqName);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"(bindingContext.get(Bind\u2026geFqName) ?: emptyList())");
            Collection ktFiles2 = collection;
            Iterable iterable = $receiver$iv = (Iterable)ktFiles2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)v1.getVirtualFile());
                collection2.add(file);
            }
            List sourceFiles = (List)destination$iv$iv;
            String relativePath = this.config.getModuleId() + '/' + JsSerializerProtocol.INSTANCE.getKjsmFilePath(packageFqName);
            return new SimpleOutputBinaryFile(sourceFiles, relativePath, bytes);
        }

        private final void getCode(TextOutput output, SourceLocationConsumer sourceLocationConsumer) {
            SourceLocationConsumer sourceLocationConsumer2 = sourceLocationConsumer;
            if (sourceLocationConsumer2 == null) {
                sourceLocationConsumer2 = NoOpSourceLocationConsumer.INSTANCE;
            }
            this.program.accept(new JsToStringGenerationVisitor(output, sourceLocationConsumer2));
        }

        @NotNull
        public final JsProgram getProgram() {
            return this.program;
        }

        @NotNull
        public final ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        public Success(@NotNull JsConfig config2, @NotNull List<? extends KtFile> files2, @NotNull JsProgram program, @NotNull Diagnostics diagnostics2, @NotNull List<String> importedModules, @NotNull ModuleDescriptor moduleDescriptor2, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
            Intrinsics.checkParameterIsNotNull(files2, (String)"files");
            Intrinsics.checkParameterIsNotNull((Object)program, (String)"program");
            Intrinsics.checkParameterIsNotNull((Object)diagnostics2, (String)"diagnostics");
            Intrinsics.checkParameterIsNotNull(importedModules, (String)"importedModules");
            Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor2, (String)"moduleDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            super(diagnostics2);
            this.config = config2;
            this.files = files2;
            this.program = program;
            this.importedModules = importedModules;
            this.moduleDescriptor = moduleDescriptor2;
            this.bindingContext = bindingContext2;
        }
    }
}

