/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\b\u001a\u0017\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00070\u0007*\u00020\b\u00a2\u0006\u0002\u0010\u0011\u001a\n\u0010\u0012\u001a\u00020\u0007*\u00020\b\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014*\u00020\b\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0014*\u00020\b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0016"}, d2={"kotlinPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "getKotlinPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinReflectionPackageFqn", "getKotlinReflectionPackageFqn", "isFunction", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isFunctionOrKFunction", "isFunctionTypeOrSubtype", "isInterface", "isKFunction", "isNullable", "isThrowable", "isThrowableTypeOrSubtype", "kotlin.jvm.PlatformType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Ljava/lang/Boolean;", "isTypeParameter", "superTypes", "", "typeParameterSuperTypes", "ir.backend.common"})
public final class IrTypeUtilsKt {
    @NotNull
    private static final FqName kotlinPackageFqn;
    @NotNull
    private static final FqName kotlinReflectionPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    @NotNull
    public static final FqName getKotlinReflectionPackageFqn() {
        return kotlinReflectionPackageFqn;
    }

    public static final boolean isFunction(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        if (irClassifierSymbol == null) {
            return false;
        }
        IrClassifierSymbol classifier = irClassifierSymbol;
        String string = classifier.getDescriptor().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classifier.descriptor.name.asString()");
        String name2 = string;
        if (!StringsKt.startsWith$default((String)name2, (String)"Function", (boolean)false, (int)2, null)) {
            return false;
        }
        IrSymbolOwner irSymbolOwner = classifier.getOwner();
        if (irSymbolOwner == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        }
        IrDeclaration declaration2 = (IrDeclaration)((Object)irSymbolOwner);
        IrDeclarationParent irDeclarationParent = declaration2.getParent();
        if (!(irDeclarationParent instanceof IrPackageFragment)) {
            irDeclarationParent = null;
        }
        IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
        if (irPackageFragment == null) {
            return false;
        }
        IrPackageFragment parent2 = irPackageFragment;
        return Intrinsics.areEqual((Object)parent2.getFqName(), (Object)kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        if (irClassifierSymbol == null) {
            return false;
        }
        IrClassifierSymbol classifier = irClassifierSymbol;
        String string = classifier.getDescriptor().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classifier.descriptor.name.asString()");
        String name2 = string;
        if (!StringsKt.startsWith$default((String)name2, (String)"KFunction", (boolean)false, (int)2, null)) {
            return false;
        }
        IrSymbolOwner irSymbolOwner = classifier.getOwner();
        if (irSymbolOwner == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        }
        IrDeclaration declaration2 = (IrDeclaration)((Object)irSymbolOwner);
        IrDeclarationParent irDeclarationParent = declaration2.getParent();
        if (!(irDeclarationParent instanceof IrPackageFragment)) {
            irDeclarationParent = null;
        }
        IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
        if (irPackageFragment == null) {
            return false;
        }
        IrPackageFragment parent2 = irPackageFragment;
        return Intrinsics.areEqual((Object)parent2.getFqName(), (Object)kotlinReflectionPackageFqn);
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $receiver) {
        List<IrType> list2;
        Object classifier;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = IrTypesKt.getClassifierOrNull($receiver);
        if (object == null || (object = object.getOwner()) == null) {
            return CollectionsKt.emptyList();
        }
        Object object2 = classifier = object;
        if (object2 instanceof IrClass) {
            list2 = ((IrClass)classifier).getSuperTypes();
        } else if (object2 instanceof IrTypeParameter) {
            list2 = ((IrTypeParameter)classifier).getSuperTypes();
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    @NotNull
    public static final List<IrType> typeParameterSuperTypes(@NotNull IrType $receiver) {
        List<IrType> list2;
        IrClassifierSymbol classifier;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        if (irClassifierSymbol == null) {
            return CollectionsKt.emptyList();
        }
        IrClassifierSymbol irClassifierSymbol2 = classifier = irClassifierSymbol;
        if (irClassifierSymbol2 instanceof IrTypeParameterSymbol) {
            list2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
        } else if (irClassifierSymbol2 instanceof IrClassSymbol) {
            list2 = CollectionsKt.emptyList();
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$receiver), isFunctionTypeOrSubtype.1.INSTANCE, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"DFS.ifAny(listOf(this), \u2026) }, { it.isFunction() })");
        return bl;
    }

    public static final boolean isTypeParameter(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IrTypesKt.getClassifierOrNull($receiver) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($receiver);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (!(irSymbolOwner instanceof IrClass)) {
            irSymbolOwner = null;
        }
        IrClass irClass = (IrClass)irSymbolOwner;
        return (irClass != null ? irClass.getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IrTypeUtilsKt.isFunction($receiver) || IrTypeUtilsKt.isKFunction($receiver);
    }

    public static final boolean isNullable(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$receiver), isNullable.1.INSTANCE, isNullable.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"DFS.ifAny(listOf(this), \u2026is IrDynamicType\n    }\n})");
        return bl;
    }

    public static final boolean isThrowable(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$receiver).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                return false;
            }
            IrClassSymbol classClassifier = irClassSymbol;
            if (Intrinsics.areEqual((Object)((IrClass)classClassifier.getOwner()).getName().asString(), (Object)"Throwable") ^ true) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier.getOwner()).getParent();
            if (!(irDeclarationParent instanceof IrPackageFragment)) {
                irDeclarationParent = null;
            }
            IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
            if (irPackageFragment == null) {
                return false;
            }
            IrPackageFragment parent2 = irPackageFragment;
            return Intrinsics.areEqual((Object)parent2.getFqName(), (Object)kotlinPackageFqn);
        }
        return false;
    }

    public static final Boolean isThrowableTypeOrSubtype(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Collection collection = CollectionsKt.listOf((Object)$receiver);
        Object object = isThrowableTypeOrSubtype.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0(function1);
        }
        return DFS.ifAny(collection, (DFS.Neighbors)object, isThrowableTypeOrSubtype.2.INSTANCE);
    }

    static {
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf((Object)"kotlin"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.fromSegments(listOf(\"kotlin\"))");
        kotlinPackageFqn = fqName2;
        FqName fqName3 = kotlinPackageFqn.child(Name.identifier("reflection"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"kotlinPackageFqn.child(N\u2026identifier(\"reflection\"))");
        kotlinReflectionPackageFqn = fqName3;
    }
}

