/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.declarations;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\r"}, d2={"isStaticMethodOfClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getDefault", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "getIrValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "putDefault", "", "expressionBody", "ir.tree"})
public final class IrFunctionKt {
    @NotNull
    public static final IrValueParameter getIrValueParameter(@NotNull IrFunction $receiver, @NotNull ValueParameterDescriptor parameter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Object object = $receiver.getValueParameters();
        int n = parameter.getIndex();
        if (n < 0 || n > CollectionsKt.getLastIndex(object)) {
            int it = n;
            throw (Throwable)((Object)new AssertionError((Object)("No IrValueParameter for " + parameter)));
        }
        object = object.get(n);
        IrValueParameter found2 = (IrValueParameter)object;
        boolean bl = Intrinsics.areEqual((Object)found2.getDescriptor(), (Object)parameter);
        if (_Assertions.ENABLED && !bl) {
            String string = "Parameter indices mismatch at " + $receiver.getDescriptor() + ": " + parameter + " != " + found2.getDescriptor();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (IrValueParameter)object;
    }

    @Nullable
    public static final IrExpressionBody getDefault(@NotNull IrFunction $receiver, @NotNull ValueParameterDescriptor parameter) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        return IrFunctionKt.getIrValueParameter($receiver, parameter).getDefaultValue();
    }

    public static final void putDefault(@NotNull IrFunction $receiver, @NotNull ValueParameterDescriptor parameter, @NotNull IrExpressionBody expressionBody) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull((Object)expressionBody, (String)"expressionBody");
        IrFunctionKt.getIrValueParameter($receiver, parameter).setDefaultValue(expressionBody);
    }

    public static final boolean isStaticMethodOfClass(@NotNull IrFunction $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver instanceof IrSimpleFunction && $receiver.getParent() instanceof IrClass && $receiver.getDispatchReceiverParameter() == null;
    }
}

