/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    public static boolean comparePublicNonFinalFieldsWithSkip(@NotNull Object first, @NotNull Object second) {
        return ReflectionUtil.comparePublicNonFinalFields(first, second, (Predicate<Field>)((Predicate)field2 -> field2.getAnnotation(SkipInEquals.class) == null));
    }

    private static boolean comparePublicNonFinalFields(@NotNull Object first, @NotNull Object second, @Nullable Predicate<Field> acceptPredicate) {
        HashSet firstFields = ContainerUtil.newHashSet((Object[])first.getClass().getFields());
        for (Field field2 : second.getClass().getFields()) {
            if (!firstFields.contains(field2) || !ReflectionUtil.isPublic(field2) || ReflectionUtil.isFinal(field2) || acceptPredicate != null && !acceptPredicate.apply((Object)field2)) continue;
            try {
                if (Comparing.equal((Object)field2.get(first), (Object)field2.get(second))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private static boolean isPublic(Field field2) {
        return (field2.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(Field field2) {
        return (field2.getModifiers() & 0x10) != 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SkipInEquals {
    }
}

