/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.JavaRefactoringSettings;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInliner.UsageReplacementStrategy;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineCallableProcessor;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0014J\u0006\u0010\u0012\u001a\u00020\u000bR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValDialog;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "reference", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "replacementStrategy", "Lorg/jetbrains/kotlin/idea/codeInliner/UsageReplacementStrategy;", "assignmentToDelete", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "withPreview", "", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;Lorg/jetbrains/kotlin/idea/codeInliner/UsageReplacementStrategy;Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Z)V", "isLocal", "simpleLocal", "doAction", "", "isInlineThis", "shouldBeShown", "idea"})
public final class KotlinInlineValDialog
extends AbstractKotlinInlineDialog {
    private final boolean isLocal;
    private final boolean simpleLocal;
    private final UsageReplacementStrategy replacementStrategy;
    private final KtBinaryExpression assignmentToDelete;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldBeShown() {
        if (!this.simpleLocal) return true;
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        if (!editorSettingsExternalizable.isShowInlineLocalDialog()) return false;
        return true;
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_LOCAL_THIS;
    }

    public void doAction() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.invokeRefactoring(new KotlinInlineCallableProcessor(project, this.replacementStrategy, this.getCallable(), this.getReference(), this.isInlineThisOnly(), !this.isInlineThisOnly() && !this.isKeepTheDeclaration(), this.assignmentToDelete));
        JavaRefactoringSettings settings2 = JavaRefactoringSettings.getInstance();
        JRadioButton jRadioButton = this.myRbInlineThisOnly;
        Intrinsics.checkExpressionValueIsNotNull((Object)jRadioButton, (String)"myRbInlineThisOnly");
        if (jRadioButton.isEnabled()) {
            JRadioButton jRadioButton2 = this.myRbInlineAll;
            Intrinsics.checkExpressionValueIsNotNull((Object)jRadioButton2, (String)"myRbInlineAll");
            if (jRadioButton2.isEnabled()) {
                settings2.INLINE_LOCAL_THIS = this.isInlineThisOnly();
            }
        }
    }

    public KotlinInlineValDialog(@NotNull KtProperty property, @Nullable KtSimpleNameReference reference2, @NotNull UsageReplacementStrategy replacementStrategy, @Nullable KtBinaryExpression assignmentToDelete, boolean withPreview) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)replacementStrategy, (String)"replacementStrategy");
        super(property, reference2, null, 4, null);
        this.replacementStrategy = replacementStrategy;
        this.assignmentToDelete = assignmentToDelete;
        KtCallableDeclaration ktCallableDeclaration = this.getCallable();
        if (ktCallableDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
        }
        this.isLocal = ((KtProperty)ktCallableDeclaration).isLocal();
        this.simpleLocal = this.isLocal && (reference2 == null || this.getOccurrencesNumber() == 1);
        this.setPreviewResults(withPreview && this.shouldBeShown());
        if (this.simpleLocal) {
            this.setDoNotAskOption(new DialogWrapper.DoNotAskOption(){

                public boolean isToBeShown() {
                    EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
                    return editorSettingsExternalizable.isShowInlineLocalDialog();
                }

                public void setToBeShown(boolean value, int exitCode) {
                    EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
                    editorSettingsExternalizable.setShowInlineLocalDialog(value);
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    return "Do not show for local variables in future";
                }
            });
        }
        this.init();
    }

    public /* synthetic */ KotlinInlineValDialog(KtProperty ktProperty, KtSimpleNameReference ktSimpleNameReference, UsageReplacementStrategy usageReplacementStrategy, KtBinaryExpression ktBinaryExpression, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(ktProperty, ktSimpleNameReference, usageReplacementStrategy, ktBinaryExpression, bl);
    }
}

