/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplacePrimitiveCastWithNumberConversionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "element", "targetShortType", "", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Factory", "idea"})
public final class ReplacePrimitiveCastWithNumberConversionFix
extends KotlinQuickFixAction<KtBinaryExpressionWithTypeRHS> {
    private final String targetShortType;
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getText() {
        return "Replace cast with call to 'to" + this.targetShortType + "()'";
    }

    @NotNull
    public String getFamilyName() {
        return "Replace cast with primitive conversion method";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        block5: {
            KtExpression ktExpression;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtBinaryExpressionWithTypeRHS ktBinaryExpressionWithTypeRHS = (KtBinaryExpressionWithTypeRHS)this.getElement();
            if (ktBinaryExpressionWithTypeRHS == null) {
                return;
            }
            KtBinaryExpressionWithTypeRHS element3 = ktBinaryExpressionWithTypeRHS;
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            PsiElement psiElement2 = (PsiElement)element3;
            Object[] objectArray = new Object[2];
            KtExpression ktExpression2 = element3.getLeft();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"element.left");
            objectArray[0] = ktExpression2;
            objectArray[1] = this.targetShortType;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "$0.to$1()", objectArray, false, 4, null);
            PsiElement result$iv = $receiver$iv.replace(newElement$iv);
            PsiElement psiElement3 = result$iv;
            if (!(psiElement3 instanceof KtExpression)) {
                psiElement3 = null;
            }
            if ((ktExpression = (KtExpression)psiElement3) == null) {
                PsiElement psiElement4 = result$iv;
                if (psiElement4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                ktExpression = ((KtParenthesizedExpression)psiElement4).getExpression();
                if (ktExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            KtExpression replaced = ktExpression;
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block5;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)replaced));
        }
    }

    public ReplacePrimitiveCastWithNumberConversionFix(@NotNull KtBinaryExpressionWithTypeRHS element3, @NotNull String targetShortType) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)targetShortType, (String)"targetShortType");
        super((PsiElement)element3);
        this.targetShortType = targetShortType;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplacePrimitiveCastWithNumberConversionFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.CAST_NEVER_SUCCEEDS.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"CAST_NEVER_SUCCEEDS.cast(diagnostic)");
            Object e = ((SimpleDiagnostic)d).getPsiElement();
            if (!(e instanceof KtOperationReferenceExpression)) {
                e = null;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)e;
            if (ktOperationReferenceExpression == null) {
                return null;
            }
            KtOperationReferenceExpression element3 = ktOperationReferenceExpression;
            PsiElement psiElement2 = element3.getParent();
            if (!(psiElement2 instanceof KtBinaryExpressionWithTypeRHS)) {
                psiElement2 = null;
            }
            KtBinaryExpressionWithTypeRHS ktBinaryExpressionWithTypeRHS = (KtBinaryExpressionWithTypeRHS)psiElement2;
            if (ktBinaryExpressionWithTypeRHS == null) {
                return null;
            }
            KtBinaryExpressionWithTypeRHS binaryExpression = ktBinaryExpressionWithTypeRHS;
            BindingContext context = ResolutionUtils.analyze$default(binaryExpression, null, 1, null);
            KtExpression ktExpression = binaryExpression.getLeft();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"binaryExpression.left");
            KotlinType kotlinType2 = CallUtilKt.getType(ktExpression, context);
            if (kotlinType2 == null) {
                return null;
            }
            KotlinType expressionType = kotlinType2;
            if (!TypeUtilsKt.isPrimitiveNumberType(expressionType)) {
                return null;
            }
            Object object = binaryExpression.getRight();
            if (object == null || (object = TypeBindingKt.createTypeBinding((KtTypeReference)object, context)) == null || (object = object.getType()) == null) {
                return null;
            }
            Object castType = object;
            if (!TypeUtilsKt.isPrimitiveNumberType((KotlinType)castType)) {
                return null;
            }
            return new ReplacePrimitiveCastWithNumberConversionFix(binaryExpression, IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.renderType((KotlinType)castType));
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

