/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0012\u0013\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "element", "typeOfError", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;", "(Lorg/jetbrains/kotlin/psi/KtNullableType;Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Factory", "LATEINIT_FACTORY", "NullableKind", "idea"})
public final class RemoveNullableFix
extends KotlinQuickFixAction<KtNullableType> {
    private final NullableKind typeOfError;

    @NotNull
    public String getFamilyName() {
        return "Remove '?'";
    }

    @NotNull
    public String getText() {
        return this.typeOfError.getMessage();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtNullableType ktNullableType = (KtNullableType)this.getElement();
        if (ktNullableType == null) {
            return;
        }
        KtNullableType element3 = ktNullableType;
        KtTypeElement ktTypeElement = element3.getInnerType();
        if (ktTypeElement == null) {
            String string = "No inner type " + element3.getText() + ", should have been rejected in createFactory()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeElement, (String)"element.innerType ?: err\u2026cted in createFactory()\")");
        KtTypeElement type2 = ktTypeElement;
        element3.replace((PsiElement)type2);
    }

    public RemoveNullableFix(@NotNull KtNullableType element3, @NotNull NullableKind typeOfError) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)typeOfError), (String)"typeOfError");
        super((PsiElement)element3);
        this.typeOfError = typeOfError;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;", "", "message", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "REDUNDANT", "SUPERTYPE", "USELESS", "PROPERTY", "idea"})
    public static final class NullableKind
    extends Enum<NullableKind> {
        public static final /* enum */ NullableKind REDUNDANT;
        public static final /* enum */ NullableKind SUPERTYPE;
        public static final /* enum */ NullableKind USELESS;
        public static final /* enum */ NullableKind PROPERTY;
        private static final /* synthetic */ NullableKind[] $VALUES;
        @NotNull
        private final String message;

        static {
            NullableKind[] nullableKindArray = new NullableKind[4];
            NullableKind[] nullableKindArray2 = nullableKindArray;
            nullableKindArray[0] = REDUNDANT = new NullableKind("Remove redundant '?'");
            nullableKindArray[1] = SUPERTYPE = new NullableKind("Remove '?'");
            nullableKindArray[2] = USELESS = new NullableKind("Remove useless '?'");
            nullableKindArray[3] = PROPERTY = new NullableKind("Make not-nullable");
            $VALUES = nullableKindArray;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        private NullableKind(String message2) {
            this.message = message2;
        }

        public static NullableKind[] values() {
            return (NullableKind[])$VALUES.clone();
        }

        public static NullableKind valueOf(String string) {
            return Enum.valueOf(NullableKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "typeOfError", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;", "(Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;)V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        private final NullableKind typeOfError;

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtNullableType> createAction(@NotNull Diagnostic diagnostic) {
            KtNullableType nullType;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement $receiver$iv = psiElement2;
            KtNullableType ktNullableType = nullType = (KtNullableType)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNullableType.class, (boolean)false);
            if ((ktNullableType != null ? ktNullableType.getInnerType() : null) == null) {
                return null;
            }
            return new RemoveNullableFix(nullType, this.typeOfError);
        }

        public Factory(@NotNull NullableKind typeOfError) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)typeOfError), (String)"typeOfError");
            this.typeOfError = typeOfError;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$LATEINIT_FACTORY;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class LATEINIT_FACTORY
    extends KotlinSingleIntentionActionFactory {
        public static final LATEINIT_FACTORY INSTANCE;

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtNullableType> createAction(@NotNull Diagnostic diagnostic) {
            Object lateinitElement;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.INAPPLICABLE_LATEINIT_MODIFIER.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.INAPPLICABLE_LATE\u2026MODIFIER.cast(diagnostic)");
            Object e = ((DiagnosticWithParameters1)d).getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"Errors.INAPPLICABLE_LATE\u2026st(diagnostic).psiElement");
            Object $receiver$iv = lateinitElement = e;
            KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType($receiver$iv, KtProperty.class, (boolean)true);
            if (ktProperty == null) {
                return null;
            }
            KtProperty property = ktProperty;
            KtTypeReference ktTypeReference = property.getTypeReference();
            if (ktTypeReference == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"property.typeReference ?: return null");
            KtTypeReference typeReference = ktTypeReference;
            KtTypeElement ktTypeElement = typeReference.getTypeElement();
            if (ktTypeElement == null) {
                return null;
            }
            KtTypeElement ktTypeElement2 = ktTypeElement;
            if (!(ktTypeElement instanceof KtNullableType)) {
                ktTypeElement2 = null;
            }
            KtNullableType ktNullableType = (KtNullableType)ktTypeElement2;
            if (ktNullableType == null) {
                return null;
            }
            KtNullableType typeElement = ktNullableType;
            if (typeElement.getInnerType() == null) {
                return null;
            }
            return new RemoveNullableFix(typeElement, NullableKind.PROPERTY);
        }

        private LATEINIT_FACTORY() {
        }

        static {
            LATEINIT_FACTORY lATEINIT_FACTORY;
            INSTANCE = lATEINIT_FACTORY = new LATEINIT_FACTORY();
        }
    }
}

