/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.idea.quickfix.DeprecatedJavaAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationMapper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/DeprecatedJavaAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "element", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "arguments", "", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Factory", "idea"})
public final class DeprecatedJavaAnnotationFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    private final FqName annotationFqName;
    private final List<KtValueArgument> arguments;
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getFamilyName() {
        return "Replace Annotation";
    }

    @NotNull
    public String getText() {
        return "Replace annotation with " + this.annotationFqName.asString();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry element3 = ktAnnotationEntry;
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            String argumentString2 = this.arguments.isEmpty() ? "" : "(" + CollectionsKt.joinToString$default((Iterable)this.arguments, (CharSequence)",", null, null, (int)0, null, (Function1)invoke.argumentString.1.INSTANCE, (int)30, null) + ")";
            element3.replace((PsiElement)psiFactory.createAnnotationEntry("@" + this.annotationFqName.shortName() + argumentString2));
            Map<FqName, FqName> map2 = JavaAnnotationMapper.INSTANCE.getJavaToKotlinNameMap();
            Iterator<Map.Entry<FqName, FqName>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object v1;
                block4: {
                    Iterable iterable;
                    Map.Entry<FqName, FqName> entry;
                    Map.Entry<FqName, FqName> entry2 = entry = iterator2.next();
                    FqName java = entry2.getKey();
                    entry2 = entry;
                    FqName kotlin = entry2.getValue();
                    if (!Intrinsics.areEqual((Object)kotlin, (Object)this.annotationFqName)) continue;
                    Iterable iterable2 = iterable = (Iterable)file.getImportDirectives();
                    for (Object t : iterable2) {
                        KtImportDirective it = (KtImportDirective)t;
                        if (!Intrinsics.areEqual((Object)it.getImportedFqName(), (Object)java)) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                KtImportDirective ktImportDirective = v1;
                if (ktImportDirective == null) {
                    return;
                }
                KtImportDirective oldImport = ktImportDirective;
                oldImport.delete();
                break;
            }
            KtImportList ktImportList = file.getImportList();
            if (ktImportList == null) break block5;
            ktImportList.add((PsiElement)psiFactory.createImportDirective(new ImportPath(this.annotationFqName, false, null)));
        }
    }

    public DeprecatedJavaAnnotationFix(@NotNull KtAnnotationEntry element3, @NotNull FqName annotationFqName, @NotNull List<? extends KtValueArgument> arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        super((PsiElement)element3);
        this.annotationFqName = annotationFqName;
        this.arguments = arguments2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/DeprecatedJavaAnnotationFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = ErrorsJvm.DEPRECATED_JAVA_ANNOTATION.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"ErrorsJvm.DEPRECATED_JAV\u2026NOTATION.cast(diagnostic)");
            DiagnosticWithParameters1 castedDiagnostic = (DiagnosticWithParameters1)d;
            Object a = castedDiagnostic.getA();
            if (!(a instanceof FqName)) {
                a = null;
            }
            FqName fqName2 = (FqName)a;
            if (fqName2 == null) {
                return null;
            }
            FqName updatedAnnotation = fqName2;
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtAnnotationEntry)) {
                psiElement2 = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            List arguments2 = new ArrayList();
            List<? extends ValueArgument> list2 = entry.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"entry.valueArguments");
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                PsiElement[] $receiver$iv2;
                ValueArgument it;
                ValueArgument valueArgument = it = (ValueArgument)element$iv;
                if (valueArgument == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgument");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((KtValueArgument)valueArgument).getChildren(), (String)"(it as KtValueArgument).children");
                PsiElement[] psiElementArray = $receiver$iv2;
                int n = psiElementArray.length;
                for (int j = 0; j < n; ++j) {
                    PsiElement element$iv2;
                    PsiElement child;
                    PsiElement psiElement3 = child = (element$iv2 = psiElementArray[j]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"child");
                    PsiElement psiElement4 = psiElement3.getContext();
                    if (psiElement4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgument");
                    }
                    arguments2.add((KtValueArgument)psiElement4);
                }
            }
            return new DeprecatedJavaAnnotationFix(entry, updatedAnnotation, arguments2);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

