/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionParametersFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.TypeUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfo;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00070\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0014J\"\u0010#\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010$\u001a\u00020\u0007H\u0002R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "callElement", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "hasTypeMismatches", "", "(Lorg/jetbrains/kotlin/psi/KtCallElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Z)V", "getCallElement", "()Lorg/jetbrains/kotlin/psi/KtCallElement;", "typesToShorten", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/types/KotlinType;", "addParameterConfiguration", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "getNewParameterInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "validator", "Lkotlin/Function1;", "", "getText", "hasOtherUsages", "function", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "isConstructor", "idea"})
public final class AddFunctionParametersFix
extends ChangeFunctionSignatureFix {
    private final ArrayList<KotlinType> typesToShorten;
    private final boolean hasTypeMismatches;

    private final KtCallElement getCallElement() {
        Object t = this.getElement();
        if (!(t instanceof KtCallElement)) {
            t = null;
        }
        return (KtCallElement)t;
    }

    @NotNull
    public String getText() {
        String string;
        String subjectSuffix;
        boolean bl;
        KtCallElement ktCallElement = this.getCallElement();
        if (ktCallElement == null) {
            return "";
        }
        KtCallElement callElement2 = ktCallElement;
        List<ValueParameterDescriptor> list2 = this.getFunctionDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionDescriptor.valueParameters");
        List<ValueParameterDescriptor> parameters2 = list2;
        List<? extends ValueArgument> list3 = callElement2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"callElement.valueArguments");
        List<? extends ValueArgument> arguments2 = list3;
        int newParametersCnt = arguments2.size() - parameters2.size();
        boolean bl2 = bl = newParametersCnt > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        String string3 = subjectSuffix = newParametersCnt > 1 ? "s" : "";
        if (this.isConstructor()) {
            DeclarationDescriptor declarationDescriptor = this.getFunctionDescriptor().getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"functionDescriptor.containingDeclaration");
            String string4 = declarationDescriptor.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"functionDescriptor.conta\u2026claration.name.asString()");
            String className2 = string4;
            string = "constructor '" + className2 + '\'';
        } else {
            String string5 = this.getFunctionDescriptor().getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"functionDescriptor.name.asString()");
            String functionName = string5;
            string = "function '" + functionName + '\'';
        }
        String callableDescription = string;
        return this.hasTypeMismatches ? "Change the signature of " + callableDescription : "Add parameter" + subjectSuffix + " to " + callableDescription;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor2, file)) {
            return false;
        }
        KtCallElement ktCallElement = this.getCallElement();
        if (ktCallElement == null) {
            return false;
        }
        KtCallElement callElement2 = ktCallElement;
        int newParametersCnt = callElement2.getValueArguments().size() - this.getFunctionDescriptor().getValueParameters().size();
        return newParametersCnt > 0;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtCallElement ktCallElement = this.getCallElement();
        if (ktCallElement == null) {
            return;
        }
        KtCallElement callElement2 = ktCallElement;
        KotlinChangeSignatureKt.runChangeSignature(project, this.getFunctionDescriptor(), this.addParameterConfiguration(), (PsiElement)callElement2, this.getText());
    }

    private final KotlinChangeSignatureConfiguration addParameterConfiguration() {
        return new KotlinChangeSignatureConfiguration(this){
            final /* synthetic */ AddFunctionParametersFix this$0;

            @NotNull
            public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(this, originalDescriptor){
                    final /* synthetic */ addParameterConfiguration.1 this$0;
                    final /* synthetic */ KotlinMethodDescriptor $originalDescriptor;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull KotlinMutableMethodDescriptor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        KtCallElement ktCallElement = AddFunctionParametersFix.access$getCallElement$p(this.this$0.this$0);
                        if (ktCallElement == null) {
                            return;
                        }
                        KtCallElement callElement2 = ktCallElement;
                        Call call2 = CallUtilKt.getCall(callElement2, ResolutionUtils.analyze$default(callElement2, null, 1, null));
                        if (call2 == null) {
                            return;
                        }
                        Call call3 = call2;
                        List<ValueParameterDescriptor> list2 = this.this$0.this$0.getFunctionDescriptor().getValueParameters();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionDescriptor.valueParameters");
                        List<ValueParameterDescriptor> parameters2 = list2;
                        List<? extends ValueArgument> list3 = callElement2.getValueArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"callElement.valueArguments");
                        List<? extends ValueArgument> arguments2 = list3;
                        CollectingNameValidator validator2 = new CollectingNameValidator(null, null, 3, null);
                        int n = 0;
                        int n2 = ((Collection)arguments2).size();
                        while (n < n2) {
                            Object it2;
                            Object object;
                            void i2;
                            ValueArgument argument2 = arguments2.get((int)i2);
                            KtExpression expression2 = argument2.getArgumentExpression();
                            if (i2 < parameters2.size()) {
                                KotlinType parameterType;
                                Object object2;
                                ValueParameterDescriptor valueParameterDescriptor = parameters2.get((int)i2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameters[i]");
                                String string = valueParameterDescriptor.getName().asString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parameters[i].name.asString()");
                                validator2.addName(string);
                                if (expression2 != null) {
                                    it2 = object;
                                    BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)it2, null, 1, null);
                                    ExplicitSmartCasts smartCasts = (ExplicitSmartCasts)bindingContext2.get(BindingContext.SMARTCAST, it2);
                                    Object object3 = smartCasts;
                                    if (object3 == null || (object3 = object3.getDefaultType()) == null) {
                                        ExplicitSmartCasts explicitSmartCasts = smartCasts;
                                        object3 = object2 = explicitSmartCasts != null ? explicitSmartCasts.type(call3) : null;
                                    }
                                    if (object3 == null) {
                                        object2 = bindingContext2.getType((KtExpression)it2);
                                    }
                                } else {
                                    object2 = null;
                                }
                                Object argumentType = object2;
                                ValueParameterDescriptor valueParameterDescriptor2 = parameters2.get((int)i2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor2, (String)"parameters[i]");
                                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor2.getType(), (String)"parameters[i].type");
                                if (argumentType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf((KotlinType)argumentType, parameterType)) {
                                    it.getParameters().get((int)i2).setCurrentTypeInfo(new KotlinTypeInfo(false, (KotlinType)argumentType, null, 4, null));
                                    AddFunctionParametersFix.access$getTypesToShorten$p(this.this$0.this$0).add(argumentType);
                                }
                            } else {
                                AddFunctionParametersFix addFunctionParametersFix = this.this$0.this$0;
                                CallableDescriptor callableDescriptor = this.$originalDescriptor.getBaseDescriptor();
                                if (callableDescriptor == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                                }
                                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
                                ValueArgument valueArgument = argument2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"argument");
                                KotlinParameterInfo parameterInfo = AddFunctionParametersFix.access$getNewParameterInfo(addFunctionParametersFix, functionDescriptor2, valueArgument, validator2);
                                if (parameterInfo.getOriginalTypeInfo().getType() != null) {
                                    it2 = object;
                                    AddFunctionParametersFix.access$getTypesToShorten$p(this.this$0.this$0).add(it2);
                                }
                                if (expression2 != null) {
                                    parameterInfo.setDefaultValueForCall(expression2);
                                }
                                it.addParameter(parameterInfo);
                            }
                            ++i2;
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$originalDescriptor = kotlinMethodDescriptor;
                        super(1);
                    }
                }));
            }

            public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                PsiElement psiElement2 = (PsiElement)CollectionsKt.singleOrNull((Iterable)affectedFunctions);
                if (psiElement2 == null) {
                    return false;
                }
                PsiElement onlyFunction = psiElement2;
                return !AddFunctionParametersFix.access$getHasTypeMismatches$p(this.this$0) && !AddFunctionParametersFix.access$isConstructor(this.this$0) && !AddFunctionParametersFix.access$hasOtherUsages(this.this$0, onlyFunction);
            }
            {
                this.this$0 = $outer;
            }

            public boolean forcePerformForSelectedFunctionOnly() {
                return KotlinChangeSignatureConfiguration.DefaultImpls.forcePerformForSelectedFunctionOnly(this);
            }
        };
    }

    private final KotlinParameterInfo getNewParameterInfo(FunctionDescriptor functionDescriptor2, ValueArgument argument2, Function1<? super String, Boolean> validator2) {
        Object object;
        KtExpression it;
        String name2 = this.getNewArgumentName(argument2, validator2);
        KtExpression expression2 = argument2.getArgumentExpression();
        Object object2 = expression2;
        if (object2 == null || (object2 = (KotlinType)CollectionsKt.firstOrNull((Iterable)TypeUtilsKt.getDataFlowAwareTypes$default(it = (object = object2), null, null, 6, null))) == null) {
            SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(functionDescriptor2).getNullableAnyType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"functionDescriptor.builtIns.nullableAnyType");
            object2 = simpleType2;
        }
        Object type2 = object2;
        Object $receiver = object = new KotlinParameterInfo(functionDescriptor2, -1, name2, new KotlinTypeInfo(false, null, null, 4, null), null, null, null, null, 240, null);
        ((KotlinParameterInfo)$receiver).setCurrentTypeInfo(new KotlinTypeInfo(false, (KotlinType)type2, null, 4, null));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasOtherUsages(PsiElement function2) {
        boolean bl;
        block3: {
            Query query = ReferencesSearch.search((PsiElement)function2);
            Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(function)");
            Iterable $receiver$iv = (Iterable)query;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    void $receiver$iv2;
                    PsiReference it;
                    PsiReference psiReference = it = (PsiReference)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReference.getElement(), (String)"it.element");
                    boolean strict$iv = false;
                    KtCallElement call2 = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtCallElement.class, (boolean)strict$iv);
                    boolean bl2 = call2 != null && Intrinsics.areEqual((Object)this.getCallElement(), (Object)call2) ^ true;
                    if (!bl2) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isConstructor() {
        return this.getFunctionDescriptor() instanceof ConstructorDescriptor;
    }

    public AddFunctionParametersFix(@NotNull KtCallElement callElement2, @NotNull FunctionDescriptor functionDescriptor2, boolean hasTypeMismatches) {
        Intrinsics.checkParameterIsNotNull((Object)callElement2, (String)"callElement");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor");
        super((PsiElement)callElement2, functionDescriptor2);
        this.hasTypeMismatches = hasTypeMismatches;
        this.typesToShorten = new ArrayList();
    }

    public static final /* synthetic */ KtCallElement access$getCallElement$p(AddFunctionParametersFix $this) {
        return $this.getCallElement();
    }

    public static final /* synthetic */ ArrayList access$getTypesToShorten$p(AddFunctionParametersFix $this) {
        return $this.typesToShorten;
    }

    public static final /* synthetic */ KotlinParameterInfo access$getNewParameterInfo(AddFunctionParametersFix $this, FunctionDescriptor functionDescriptor2, ValueArgument argument2, Function1 validator2) {
        return $this.getNewParameterInfo(functionDescriptor2, argument2, (Function1<? super String, Boolean>)validator2);
    }

    public static final /* synthetic */ boolean access$getHasTypeMismatches$p(AddFunctionParametersFix $this) {
        return $this.hasTypeMismatches;
    }

    public static final /* synthetic */ boolean access$isConstructor(AddFunctionParametersFix $this) {
        return $this.isConstructor();
    }

    public static final /* synthetic */ boolean access$hasOtherUsages(AddFunctionParametersFix $this, PsiElement function2) {
        return $this.hasOtherUsages(function2);
    }
}

