/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.ConvertToScopeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u000e*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0004*\u00020\u000eH\u0002R\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToApplyOrAlsoIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToScopeIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isAlso", "", "(Z)V", "isParameterScopeFunction", "()Z", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "createScopeExpression", "Lorg/jetbrains/kotlin/psi/KtProperty;", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "findCallExpressionFrom", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "scopeExpression", "isApplicableTo", "caretOffset", "", "findTargetProperty", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "receiverExpressionText", "", "isApplicable", "Companion", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToApplyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertToAlsoIntention;", "idea"})
public abstract class ConvertToApplyOrAlsoIntention
extends ConvertToScopeIntention<KtExpression> {
    private final boolean isParameterScopeFunction;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isParameterScopeFunction() {
        return this.isParameterScopeFunction;
    }

    @Override
    @Nullable
    protected KtCallExpression findCallExpressionFrom(@NotNull KtExpression scopeExpression) {
        Intrinsics.checkParameterIsNotNull((Object)scopeExpression, (String)"scopeExpression");
        KtExpression ktExpression = scopeExpression;
        if (!(ktExpression instanceof KtProperty)) {
            ktExpression = null;
        }
        KtProperty ktProperty = (KtProperty)ktExpression;
        KtExpression ktExpression2 = ktProperty != null ? ktProperty.getInitializer() : null;
        if (!(ktExpression2 instanceof KtQualifiedExpression)) {
            ktExpression2 = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        return ktQualifiedExpression != null ? UtilsKt.getCallExpression(ktQualifiedExpression) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        if (!(ktExpression instanceof KtProperty)) {
            if (!(ktExpression instanceof KtDotQualifiedExpression)) return false;
            String receiverExpressionText = UtilsKt.getLeftMostReceiverExpression((KtDotQualifiedExpression)element3).getText();
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)element3;
            String string = receiverExpressionText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"receiverExpressionText");
            if (!this.isApplicableWithGivenReceiverText(ktDotQualifiedExpression, string)) return false;
            KtProperty ktProperty = this.findTargetProperty((KtDotQualifiedExpression)element3, receiverExpressionText);
            if (ktProperty == null) return false;
            boolean bl = this.isApplicable(ktProperty);
            if (!bl) return false;
            return true;
        }
        boolean bl = this.isApplicable((KtProperty)element3);
        return bl;
    }

    private final boolean isApplicable(@NotNull KtProperty $receiver) {
        if (!$receiver.isLocal()) {
            return false;
        }
        String string = $receiver.getName();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name ?: return false");
        String localVariableName = string;
        KtDotQualifiedExpression firstDotQualified = this.getDotQualifiedSiblingIfAny($receiver, true);
        if (firstDotQualified != null && this.isApplicableWithGivenReceiverText(firstDotQualified, localVariableName)) {
            KtDotQualifiedExpression nextDotQualified = this.getDotQualifiedSiblingIfAny(firstDotQualified, true);
            return nextDotQualified != null && this.isApplicableWithGivenReceiverText(nextDotQualified, localVariableName);
        }
        return false;
    }

    private final KtProperty findTargetProperty(@NotNull KtDotQualifiedExpression $receiver, String receiverExpressionText) {
        PsiElement target = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments((PsiElement)$receiver, false);
        PsiElement psiElement2 = target;
        if (psiElement2 instanceof KtProperty) {
            if (Intrinsics.areEqual((Object)((KtProperty)target).getName(), (Object)receiverExpressionText)) {
                return (KtProperty)target;
            }
        } else if (psiElement2 instanceof KtDotQualifiedExpression && this.isApplicableWithGivenReceiverText((KtDotQualifiedExpression)target, receiverExpressionText)) {
            return this.findTargetProperty((KtDotQualifiedExpression)target, receiverExpressionText);
        }
        return null;
    }

    @Override
    public void applyTo(@NotNull KtExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        if (ktExpression instanceof KtProperty) {
            String string = ((KtProperty)element3).getName();
            if (string == null) {
                return;
            }
            this.applyWithGivenReceiverText(element3, string);
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            String string = this.getReceiverExpressionText((KtDotQualifiedExpression)element3);
            if (string == null) {
                return;
            }
            String receiverExpressionText = string;
            KtProperty ktProperty = this.findTargetProperty((KtDotQualifiedExpression)element3, receiverExpressionText);
            if (ktProperty == null) {
                return;
            }
            KtProperty property = ktProperty;
            this.applyWithGivenReceiverText((KtExpression)property, receiverExpressionText);
        }
    }

    @Nullable
    protected KtProperty createScopeExpression(@NotNull KtPsiFactory factory2, @NotNull KtExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!(element3 instanceof KtProperty)) {
            return null;
        }
        String string = ((KtProperty)element3).getName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name ?: return null");
        String receiverExpressionText = string;
        KtTypeReference ktTypeReference = ((KtProperty)element3).getTypeReference();
        KtExpression ktExpression = ((KtProperty)element3).getInitializer();
        return factory2.createProperty(receiverExpressionText, ktTypeReference != null ? ktTypeReference.getText() : null, ((KtProperty)element3).isVar(), (ktExpression != null ? ktExpression.getText() : null) + '.' + Companion.scopeFunctionName(this.isParameterScopeFunction()) + "{}");
    }

    private ConvertToApplyOrAlsoIntention(boolean isAlso) {
        super(KtExpression.class, "Convert to " + Companion.scopeFunctionName(isAlso));
        this.isParameterScopeFunction = isAlso;
    }

    public /* synthetic */ ConvertToApplyOrAlsoIntention(boolean isAlso, DefaultConstructorMarker $constructor_marker) {
        this(isAlso);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToApplyOrAlsoIntention$Companion;", "", "()V", "scopeFunctionName", "", "isParameterScopeFunction", "", "idea"})
    public static final class Companion {
        @NotNull
        public final String scopeFunctionName(boolean isParameterScopeFunction) {
            return isParameterScopeFunction ? "also" : "apply";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

