/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.SimplifyNegatedBinaryExpressionInspection;
import org.jetbrains.kotlin.idea.intentions.ConvertIfWithThrowToAssertIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertIfWithThrowToAssertIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "getSelector", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isApplicableTo", "", "idea"})
public final class ConvertIfWithThrowToAssertIntention
extends SelfTargetingOffsetIndependentIntention<KtIfExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtIfExpression element3) {
        KtThrowExpression throwExpr;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3.getElse() != null) {
            return false;
        }
        KtExpression ktExpression = element3.getThen();
        KtExpression ktExpression2 = ktExpression != null ? IfThenUtilsKt.unwrapBlockOrParenthesis(ktExpression) : null;
        if (!(ktExpression2 instanceof KtThrowExpression)) {
            ktExpression2 = null;
        }
        KtThrowExpression ktThrowExpression = throwExpr = (KtThrowExpression)ktExpression2;
        KtExpression thrownExpr = this.getSelector(ktThrowExpression != null ? ktThrowExpression.getThrownExpression() : null);
        if (!(thrownExpr instanceof KtCallExpression)) {
            return false;
        }
        if (((KtCallExpression)thrownExpr).getValueArguments().size() > 1) {
            return false;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(thrownExpr, null, 1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        String string = DescriptorUtils.getFqName((DeclarationDescriptor)resolvedCall3.getResultingDescriptor()).asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DescriptorUtils.getFqNam\u2026ingDescriptor).asString()");
        String targetFqName = string;
        return ((Set)AddToStdlibKt.constant(isApplicableTo.1.INSTANCE)).contains(targetFqName);
    }

    @Override
    public void applyTo(@NotNull KtIfExpression element3, @Nullable Editor editor2) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression2 = element3.getCondition();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"element.condition ?: return");
        KtExpression condition2 = ktExpression2;
        KtExpression ktExpression3 = element3.getThen();
        KtExpression ktExpression4 = ktExpression3 != null ? IfThenUtilsKt.unwrapBlockOrParenthesis(ktExpression3) : null;
        if (ktExpression4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThrowExpression");
        }
        KtThrowExpression thenExpr = (KtThrowExpression)ktExpression4;
        KtExpression ktExpression5 = this.getSelector(thenExpr.getThrownExpression());
        if (ktExpression5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        KtCallExpression thrownExpr = (KtCallExpression)ktExpression5;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        condition2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, "!$0", new Object[]{condition2}, false, 4, null));
        KtExpression ktExpression6 = element3.getCondition();
        if (ktExpression6 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"element.condition!!");
        KtExpression newCondition = ktExpression6;
        SimplifyNegatedBinaryExpressionInspection simplifier = new SimplifyNegatedBinaryExpressionInspection();
        KtExpression ktExpression7 = newCondition;
        if (ktExpression7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrefixExpression");
        }
        if (simplifier.isApplicable((KtPrefixExpression)ktExpression7)) {
            KtSimpleNameExpression ktSimpleNameExpression = ((KtPrefixExpression)newCondition).getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"newCondition.operationReference");
            AbstractApplicabilityBasedInspection.applyTo$default(simplifier, (PsiElement)ktSimpleNameExpression, null, editor2, 2, null);
            KtExpression ktExpression8 = element3.getCondition();
            if (ktExpression8 == null) {
                Intrinsics.throwNpe();
            }
            newCondition = ktExpression8;
        }
        List<KtValueArgument> list2 = thrownExpr.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"thrownExpr.valueArguments");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull(list2);
        KtExpression arg = ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
        KtExpression assertExpr = arg != null && !IfThenUtilsKt.isNullExpression(arg) ? CreateByPatternKt.createExpressionByPattern$default(psiFactory, "kotlin.assert($0) {$1}", new Object[]{newCondition, arg}, false, 4, null) : CreateByPatternKt.createExpressionByPattern$default(psiFactory, "kotlin.assert($0)", new Object[]{newCondition}, false, 4, null);
        PsiElement $receiver$iv = (PsiElement)element3;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)assertExpr);
        PsiElement psiElement2 = result$iv;
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        if ((ktExpression = (KtExpression)psiElement2) == null) {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            ktExpression = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        KtExpression newExpr = ktExpression;
        ShortenReferences.process$default(ShortenReferences.DEFAULT, newExpr, null, 2, null);
    }

    private final KtExpression getSelector(KtExpression element3) {
        if (element3 instanceof KtDotQualifiedExpression) {
            return ((KtDotQualifiedExpression)element3).getSelectorExpression();
        }
        return element3;
    }

    public ConvertIfWithThrowToAssertIntention() {
        super(KtIfExpression.class, "Replace 'if' with 'assert' statement", null, 4, null);
    }
}

