/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceStringInDocumentFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "oldString", "", "newString", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Ljava/lang/String;)V", "elementRef", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "idea"})
public final class ReplaceStringInDocumentFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiElement> elementRef;
    private final String oldString;
    private final String newString;

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        String string;
        String text2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement2 = this.elementRef.getElement();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elementRef.element ?: return");
        PsiElement element3 = psiElement2;
        PsiFile psiFile = element3.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return;
        }
        PsiFile virtualFile = psiFile;
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026nt(virtualFile) ?: return");
        Document document2 = document;
        String string2 = text2 = element3.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
        int index2 = StringsKt.indexOf$default((CharSequence)string2, (String)this.oldString, (int)0, (boolean)false, (int)6, null);
        if (index2 < 0) {
            return;
        }
        int start2 = element3.getTextOffset() + index2;
        int end = start2 + this.oldString.length();
        String string3 = document2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"document.text");
        String documentText = string3;
        if (end > documentText.length()) {
            return;
        }
        String string4 = string = documentText;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(start2, end);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        if (Intrinsics.areEqual((Object)string5, (Object)this.oldString) ^ true) {
            return;
        }
        document2.replaceString(start2, end, (CharSequence)this.newString);
    }

    @NotNull
    public String getFamilyName() {
        return "Replace '" + this.oldString + "' with '" + this.newString + '\'';
    }

    public ReplaceStringInDocumentFix(@NotNull PsiElement element3, @NotNull String oldString, @NotNull String newString) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)oldString, (String)"oldString");
        Intrinsics.checkParameterIsNotNull((Object)newString, (String)"newString");
        this.oldString = oldString;
        this.newString = newString;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element3.getProject()).createSmartPsiElementPointer(element3);
        Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"SmartPointerManager.getI\u2026siElementPointer(element)");
        this.elementRef = smartPsiElementPointer;
    }
}

