/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.inspections.NamingConventionOptionsPanel;
import org.jetbrains.kotlin.idea.inspections.NamingRule;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0004J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0004J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0004R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "entityName", "", "defaultNamePattern", "rules", "", "Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "(Ljava/lang/String;Ljava/lang/String;[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;)V", "getDefaultNamePattern", "()Ljava/lang/String;", "value", "namePattern", "getNamePattern", "setNamePattern", "(Ljava/lang/String;)V", "nameRegex", "Lkotlin/text/Regex;", "getNameRegex", "()Lkotlin/text/Regex;", "setNameRegex", "(Lkotlin/text/Regex;)V", "[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "createOptionsPanel", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionOptionsPanel;", "getDefaultErrorMessage", "getNameMismatchMessage", "name", "verifyName", "", "element", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "idea"})
public abstract class NamingConventionInspection
extends AbstractKotlinInspection {
    @Nullable
    private Regex nameRegex;
    @NotNull
    private String namePattern;
    private final String entityName;
    @NotNull
    private final String defaultNamePattern;
    private final NamingRule[] rules;

    @Nullable
    protected final Regex getNameRegex() {
        return this.nameRegex;
    }

    protected final void setNameRegex(@Nullable Regex regex) {
        this.nameRegex = regex;
    }

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String value) {
        NamingConventionInspection namingConventionInspection;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.namePattern = value;
        NamingConventionInspection namingConventionInspection2 = this;
        try {
            string = value;
            NamingConventionInspection namingConventionInspection3 = namingConventionInspection2;
            Regex regex = new Regex(string);
            namingConventionInspection = namingConventionInspection3;
            string = regex;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            namingConventionInspection = namingConventionInspection2;
            string = null;
        }
        namingConventionInspection.nameRegex = string;
    }

    protected final void verifyName(@NotNull PsiNameIdentifierOwner element3, @NotNull ProblemsHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        String name2 = element3.getName();
        PsiElement nameIdentifier = element3.getNameIdentifier();
        if (name2 != null && nameIdentifier != null) {
            Regex regex = this.nameRegex;
            if (regex != null) {
                if (!regex.matches((CharSequence)name2)) {
                    String message2 = this.getNameMismatchMessage(name2);
                    PsiElement psiElement2 = element3.getNameIdentifier();
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    holder.registerProblem(psiElement2, this.entityName + " name <code>#ref</code> " + message2 + " #loc", new LocalQuickFix[]{new RenameIdentifierFix()});
                }
            }
        }
    }

    @NotNull
    protected final String getNameMismatchMessage(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (Intrinsics.areEqual((Object)this.namePattern, (Object)this.defaultNamePattern) ^ true) {
            return this.getDefaultErrorMessage();
        }
        String string = NamingConventionInspectionsKt.access$findRuleMessage(name2, this.rules);
        if (string == null) {
            string = this.getDefaultErrorMessage();
        }
        return string;
    }

    @NotNull
    protected final String getDefaultErrorMessage() {
        return "doesn't match regex '" + this.namePattern + '\'';
    }

    @NotNull
    public NamingConventionOptionsPanel createOptionsPanel() {
        return new NamingConventionOptionsPanel(this);
    }

    @NotNull
    protected final String getDefaultNamePattern() {
        return this.defaultNamePattern;
    }

    public NamingConventionInspection(@NotNull String entityName, @Language(value="RegExp") @NotNull String defaultNamePattern, NamingRule ... rules) {
        Regex regex;
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        Intrinsics.checkParameterIsNotNull((Object)defaultNamePattern, (String)"defaultNamePattern");
        Intrinsics.checkParameterIsNotNull((Object)rules, (String)"rules");
        this.entityName = entityName;
        this.defaultNamePattern = defaultNamePattern;
        this.rules = rules;
        String string = this.defaultNamePattern;
        NamingConventionInspection namingConventionInspection = this;
        namingConventionInspection.nameRegex = regex = new Regex(string);
        this.namePattern = this.defaultNamePattern;
    }
}

