/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.dsl.DslHighlighterExtension;
import org.jetbrains.kotlin.idea.highlighter.dsl.DslHighlighterExtensionKt;
import org.jetbrains.kotlin.idea.highlighter.markers.DslHighlightingMarkerKt;
import org.jetbrains.kotlin.psi.KtClass;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0012\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"navHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "Lcom/intellij/psi/PsiElement;", "toolTipHandler", "Lcom/intellij/util/Function;", "", "collectHighlightingColorsMarkers", "", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "createIcon", "Ljavax/swing/Icon;", "styleId", "", "styleIdForMarkerAnnotation", "(Lorg/jetbrains/kotlin/psi/KtClass;)Ljava/lang/Integer;", "idea"})
public final class DslHighlightingMarkerKt {
    private static final GutterIconNavigationHandler<PsiElement> navHandler = navHandler.1.INSTANCE;
    private static final Function<PsiElement, String> toolTipHandler = toolTipHandler.1.INSTANCE;

    public static final void collectHighlightingColorsMarkers(@NotNull KtClass ktClass2, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull((Object)ktClass2, (String)"ktClass");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        Integer n = DslHighlightingMarkerKt.styleIdForMarkerAnnotation(ktClass2);
        if (n == null) {
            return;
        }
        int styleId = n;
        PsiElement psiElement2 = ktClass2.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"ktClass.nameIdentifier ?: return");
        PsiElement anchor2 = psiElement2;
        result2.add(new LineMarkerInfo(anchor2, anchor2.getTextRange(), DslHighlightingMarkerKt.createIcon(styleId), 11, toolTipHandler, navHandler, GutterIconRenderer.Alignment.RIGHT));
    }

    private static final Icon createIcon(int styleId) {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        EditorColorsScheme globalScheme = editorColorsScheme;
        TextAttributes textAttributes = globalScheme.getAttributes(DslHighlighterExtension.Companion.styleById(styleId));
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"globalScheme.getAttribut\u2026nsion.styleById(styleId))");
        Color markersColor = textAttributes.getForegroundColor();
        Color color = globalScheme.getDefaultForeground();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"globalScheme.defaultForeground");
        Color defaultColor = color;
        JBUI.JBIcon jBIcon = JBUI.scale((JBUI.JBIcon)((JBUI.JBIcon)new ColorsIcon(12, new Color[]{markersColor, defaultColor, defaultColor, markersColor})));
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIcon, (String)"JBUI.scale(ColorsIcon(12\u2026aultColor, markersColor))");
        return (Icon)jBIcon;
    }

    private static final Integer styleIdForMarkerAnnotation(@NotNull KtClass $receiver) {
        DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor($receiver);
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        if (classDescriptor3.getKind() != ClassKind.ANNOTATION_CLASS) {
            return null;
        }
        if (!DslHighlighterExtensionKt.isDslHighlightingMarker(classDescriptor3)) {
            return null;
        }
        return DslHighlighterExtension.Companion.styleIdByMarkerAnnotation(classDescriptor3);
    }

    public static final /* synthetic */ Integer access$styleIdForMarkerAnnotation(KtClass $receiver) {
        return DslHighlightingMarkerKt.styleIdForMarkerAnnotation($receiver);
    }
}

