/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLoweringKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "()V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend"})
public final class StaticDefaultFunctionLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        irClass.accept(this, null);
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration2) {
        IrStatement irStatement;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) && declaration2.getDispatchReceiverParameter() != null) {
            DeclarationDescriptor declarationDescriptor = declaration2.getDescriptor().getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassOrPackageFragmentDescriptor classOrPackageFragmentDescriptor = (ClassDescriptor)declarationDescriptor;
            Name name2 = declaration2.getDescriptor().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"declaration.descriptor.name");
            FunctionDescriptor functionDescriptor2 = declaration2.getDescriptor();
            IrValueParameter irValueParameter = declaration2.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            KotlinType kotlinType2 = irValueParameter.getDescriptor().getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"declaration.dispatchRece\u2026rameter!!.descriptor.type");
            SimpleFunctionDescriptorImpl newFunction = InterfaceLoweringKt.createStaticFunctionWithReceivers(classOrPackageFragmentDescriptor, name2, functionDescriptor2, kotlinType2);
            FunctionDescriptor functionDescriptor3 = newFunction;
            IrDeclarationParent irDeclarationParent = declaration2.getParent();
            Visibility visibility = Visibilities.PUBLIC;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PUBLIC");
            irStatement = InterfaceLoweringKt.createFunctionAndMapVariables$default(functionDescriptor3, declaration2, irDeclarationParent, visibility, null, null, 24, null);
        } else {
            irStatement = super.visitFunction(declaration2);
        }
        return irStatement;
    }

    public StaticDefaultFunctionLowering() {
    }

    public StaticDefaultFunctionLowering(@NotNull BackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

