/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.lang.Language;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.AbstractLightClass;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightAbstractAnnotation;
import org.jetbrains.kotlin.asJava.elements.KtLightDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

public class KtLightTypeParameter
extends AbstractLightClass
implements PsiTypeParameter,
KtLightDeclaration<KtTypeParameter, PsiTypeParameter> {
    private final PsiTypeParameterListOwner owner;
    private final int index;
    private final String name;

    public KtLightTypeParameter(@NotNull PsiTypeParameterListOwner owner, int index2, @NotNull String name2) {
        super(owner.getManager(), (Language)KotlinLanguage.INSTANCE);
        this.owner = owner;
        this.index = index2;
        this.name = name2;
    }

    @Override
    @NotNull
    public PsiTypeParameter getClsDelegate() {
        return this.getOwnerDelegate().getTypeParameters()[this.index];
    }

    @NotNull
    public PsiClass getDelegate() {
        return this.getClsDelegate();
    }

    @Override
    @NotNull
    public KtTypeParameter getKotlinOrigin() {
        KtTypeParameterListOwner jetOwner = (KtTypeParameterListOwner)LightClassUtilsKt.getUnwrapped((PsiElement)this.owner);
        assert (jetOwner != null) : "Invalid type parameter owner: " + this.owner;
        return jetOwner.getTypeParameters().get(this.index);
    }

    @NotNull
    private PsiTypeParameterListOwner getOwnerDelegate() {
        if (this.owner instanceof KtLightClass) {
            return (PsiTypeParameterListOwner)((KtLightClass)this.owner).getClsDelegate();
        }
        if (this.owner instanceof KtLightMethod) {
            return (PsiTypeParameterListOwner)((KtLightMethod)this.owner).getClsDelegate();
        }
        return this.owner;
    }

    @NotNull
    public PsiElement copy() {
        return new KtLightTypeParameter(this.owner, this.index, this.name);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeParameter((PsiTypeParameter)this);
        } else {
            super.accept(visitor2);
        }
    }

    public String getText() {
        return "";
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public PsiTypeParameterListOwner getOwner() {
        return this.owner;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        return this.getClsDelegate().getAnnotations();
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getClsDelegate().getApplicableAnnotations();
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName2) {
        return this.getClsDelegate().findAnnotation(qualifiedName2);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName2) {
        return this.getClsDelegate().addAnnotation(qualifiedName2);
    }

    public String toString() {
        return "KotlinLightTypeParameter:" + this.getName();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.getKotlinOrigin();
    }

    @NotNull
    public Language getLanguage() {
        return KotlinLanguage.INSTANCE;
    }

    @NotNull
    public SearchScope getUseScope() {
        return this.getKotlinOrigin().getUseScope();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof KtLightTypeParameter && this.getKotlinOrigin().equals(((KtLightTypeParameter)obj).getKotlinOrigin());
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof PsiTypeParameter) {
            PsiTypeParameter anotherTypeParameter = (PsiTypeParameter)another;
            PsiTypeParameterListOwner owner = this.getOwner();
            if (owner != null) {
                return owner.isEquivalentTo((PsiElement)anotherTypeParameter.getOwner()) && this.getIndex() == anotherTypeParameter.getIndex();
            }
        }
        return false;
    }

    @Override
    @Nullable
    public List<KtLightAbstractAnnotation> getGivenAnnotations() {
        return null;
    }
}

