/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import javax.inject.Inject;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.DefaultInstantiatorFactory;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerServer;

public class WorkerDaemonServer
extends DefaultWorkerServer {
    private static final ProcessEnvironment PROCESS_ENVIRONMENT = NativeServices.getInstance().get(ProcessEnvironment.class);
    private static final InstantiatorFactory INSTANTIATOR_FACTORY = new DefaultInstantiatorFactory(new AsmBackedClassGenerator(), new CrossBuildInMemoryCacheFactory(new DefaultListenerManager()));
    private final WorkerDirectoryProvider workerDirectoryProvider;

    @Inject
    WorkerDaemonServer(WorkerDirectoryProvider workerDirectoryProvider) {
        super(INSTANTIATOR_FACTORY.inject());
        this.workerDirectoryProvider = workerDirectoryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        try {
            PROCESS_ENVIRONMENT.maybeSetProcessDir(spec.getExecutionWorkingDir());
            DefaultWorkResult defaultWorkResult = super.execute(spec);
            return defaultWorkResult;
        }
        catch (Throwable t) {
            DefaultWorkResult defaultWorkResult = new DefaultWorkResult(true, t);
            return defaultWorkResult;
        }
        finally {
            PROCESS_ENVIRONMENT.maybeSetProcessDir(this.workerDirectoryProvider.getIdleWorkingDirectory());
        }
    }

    @Override
    public String toString() {
        return "WorkerDaemonServer{}";
    }
}

