/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.plugin.management.internal.DefaultPluginRequest;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;
import org.gradle.util.CollectionUtils;

public class PluginRequestCollector {
    private final ScriptSource scriptSource;
    private final List<DependencySpecImpl> specs = new LinkedList<DependencySpecImpl>();

    public PluginRequestCollector(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public PluginDependenciesSpec createSpec(final int lineNumber) {
        return new PluginDependenciesSpec(){

            @Override
            public PluginDependencySpec id(String id) {
                DependencySpecImpl spec = new DependencySpecImpl(id, lineNumber);
                PluginRequestCollector.this.specs.add(spec);
                return spec;
            }
        };
    }

    public PluginRequests getPluginRequests() {
        if (this.specs.isEmpty()) {
            return DefaultPluginRequests.EMPTY;
        }
        return new DefaultPluginRequests(this.listPluginRequests());
    }

    @VisibleForTesting
    List<PluginRequestInternal> listPluginRequests() {
        List<PluginRequestInternal> pluginRequests = CollectionUtils.collect(this.specs, new Transformer<PluginRequestInternal, DependencySpecImpl>(){

            @Override
            public PluginRequestInternal transform(DependencySpecImpl original) {
                return new DefaultPluginRequest(original.id, original.version, original.apply, (Integer)original.lineNumber, PluginRequestCollector.this.scriptSource);
            }
        });
        Map<PluginId, Collection<PluginRequestInternal>> groupedById = CollectionUtils.groupBy(pluginRequests, new Transformer<PluginId, PluginRequestInternal>(){

            @Override
            public PluginId transform(PluginRequestInternal pluginRequest) {
                return pluginRequest.getId();
            }
        });
        for (PluginId key : groupedById.keySet()) {
            Collection<PluginRequestInternal> pluginRequestsForId = groupedById.get(key);
            if (pluginRequestsForId.size() <= 1) continue;
            Iterator<PluginRequestInternal> iterator = pluginRequestsForId.iterator();
            PluginRequestInternal first = iterator.next();
            PluginRequestInternal second = iterator.next();
            InvalidPluginRequestException exception = new InvalidPluginRequestException(second, "Plugin with id '" + key + "' was already requested at line " + first.getLineNumber());
            throw new LocationAwareException((Throwable)exception, second.getScriptDisplayName(), second.getLineNumber());
        }
        return pluginRequests;
    }

    private static class DependencySpecImpl
    implements PluginDependencySpec {
        private final PluginId id;
        private String version;
        private boolean apply;
        private final int lineNumber;

        private DependencySpecImpl(String id, int lineNumber) {
            this.id = DefaultPluginId.of(id);
            this.apply = true;
            this.lineNumber = lineNumber;
        }

        @Override
        public PluginDependencySpec version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public PluginDependencySpec apply(boolean apply) {
            this.apply = apply;
            return this;
        }
    }
}

