/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.platform.base.BinaryTasksCollection;

public class BinaryTasksCollectionWrapper
implements BinaryTasksCollection {
    private final BinaryTasksCollection delegate;

    public BinaryTasksCollectionWrapper(BinaryTasksCollection delegate) {
        this.delegate = delegate;
    }

    public <T extends Task> T findSingleTaskWithType(Class<T> type) {
        DomainObjectCollection tasks = this.withType(type);
        if (tasks.size() == 0) {
            return null;
        }
        if (tasks.size() > 1) {
            throw new UnknownDomainObjectException(String.format("Multiple tasks with type '%s' found.", type.getSimpleName()));
        }
        return (T)((Task)tasks.iterator().next());
    }

    @Override
    public String taskName(String verb) {
        return this.delegate.taskName(verb);
    }

    @Override
    public String taskName(String verb, String object) {
        return this.delegate.taskName(verb, object);
    }

    @Override
    public Task getBuild() {
        return this.delegate.getBuild();
    }

    @Override
    public Task getCheck() {
        return this.delegate.getCheck();
    }

    @Override
    public <T extends Task> void create(String name, Class<T> type, Action<? super T> config) {
        this.delegate.create(name, type, config);
    }

    @Override
    public <S extends Task> DomainObjectSet<S> withType(Class<S> type) {
        return this.delegate.withType(type);
    }

    @Override
    public DomainObjectSet<Task> matching(Spec<? super Task> spec) {
        return this.delegate.matching(spec);
    }

    @Override
    public DomainObjectSet<Task> matching(Closure spec) {
        return this.delegate.matching(spec);
    }

    @Override
    public Set<Task> findAll(Closure spec) {
        return this.delegate.findAll(spec);
    }

    @Override
    public <S extends Task> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        return this.delegate.withType(type, configureAction);
    }

    @Override
    public <S extends Task> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        return this.delegate.withType(type, configureClosure);
    }

    @Override
    public Action<? super Task> whenObjectAdded(Action<? super Task> action) {
        return this.delegate.whenObjectAdded(action);
    }

    @Override
    public void whenObjectAdded(Closure action) {
        this.delegate.whenObjectAdded(action);
    }

    @Override
    public Action<? super Task> whenObjectRemoved(Action<? super Task> action) {
        return this.delegate.whenObjectRemoved(action);
    }

    @Override
    public void whenObjectRemoved(Closure action) {
        this.delegate.whenObjectRemoved(action);
    }

    @Override
    public void all(Action<? super Task> action) {
        this.delegate.all(action);
    }

    @Override
    public void all(Closure action) {
        this.delegate.all(action);
    }

    @Override
    public void configureEach(Action<? super Task> action) {
        this.delegate.configureEach(action);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<Task> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(Task task) {
        return this.delegate.add(task);
    }

    @Override
    public void addLater(Provider<? extends Task> provider) {
        this.delegate.addLater(provider);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Task> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }
}

