/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.nativeplatform.internal.modulemap.GenerateModuleMapFile;
import org.gradle.nativeplatform.internal.modulemap.ModuleMap;

public class NativeDependencyCache
implements Stoppable {
    private final PersistentCache cache;
    private final FileHasher fileHasher;

    public NativeDependencyCache(CacheRepository cacheRepository, FileHasher fileHasher) {
        this.cache = cacheRepository.cache("native-dep").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
        this.fileHasher = fileHasher;
    }

    public File getUnpackedHeaders(final File headersZip, final String baseName) {
        final String hash = HashUtil.compactStringFor(this.fileHasher.hash(headersZip));
        return this.cache.useCache(new Factory<File>(){

            @Override
            public File create() {
                File dir = new File(NativeDependencyCache.this.cache.getBaseDir(), hash + "/" + baseName);
                if (dir.isDirectory()) {
                    return dir;
                }
                try {
                    NativeDependencyCache.this.unzipTo(headersZip, dir);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not unzip headers from " + headersZip, e);
                }
                return dir;
            }
        });
    }

    public File getModuleMapFile(final ModuleMap moduleMap) {
        final String hash = HashUtil.compactStringFor(moduleMap.getHashCode());
        return this.cache.useCache(new Factory<File>(){

            @Override
            public File create() {
                File dir = new File(NativeDependencyCache.this.cache.getBaseDir(), "maps/" + hash + "/" + moduleMap.getModuleName());
                File moduleMapFile = new File(dir, "module.modulemap");
                if (!moduleMapFile.isFile()) {
                    GenerateModuleMapFile.generateFile(moduleMapFile, moduleMap.getModuleName(), moduleMap.getPublicHeaderPaths());
                }
                return moduleMapFile;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipTo(File headersZip, File unzipDir) throws IOException {
        try (ZipInputStream inputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(headersZip)));){
            ZipEntry entry = null;
            while ((entry = inputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File outFile = new File(unzipDir, entry.getName());
                Files.createParentDirs((File)outFile);
                try (FileOutputStream outputStream = new FileOutputStream(outFile);){
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
        }
    }

    @Override
    public void stop() {
        this.cache.close();
    }
}

