/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transfer.ResourceOperation;

public class ProgressLoggingExternalResourceUploader
extends AbstractProgressLoggingHandler
implements ExternalResourceUploader {
    private final ExternalResourceUploader delegate;

    public ProgressLoggingExternalResourceUploader(ExternalResourceUploader delegate, ProgressLoggerFactory progressLoggerFactory) {
        super(progressLoggerFactory);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(ReadableContent resource, URI destination) throws IOException {
        ResourceOperation uploadOperation = this.createResourceOperation(destination, ResourceOperation.Type.upload, this.getClass(), resource.getContentLength());
        try {
            this.delegate.upload(new ProgressLoggingReadableContent(resource, uploadOperation), destination);
        }
        finally {
            uploadOperation.completed();
        }
    }

    private class ProgressLoggingReadableContent
    implements ReadableContent {
        private final ReadableContent delegate;
        private final ResourceOperation uploadOperation;

        private ProgressLoggingReadableContent(ReadableContent delegate, ResourceOperation uploadOperation) {
            this.delegate = delegate;
            this.uploadOperation = uploadOperation;
        }

        @Override
        public InputStream open() {
            return new AbstractProgressLoggingHandler.ProgressLoggingInputStream(this.delegate.open(), this.uploadOperation);
        }

        @Override
        public long getContentLength() {
            return this.delegate.getContentLength();
        }
    }
}

