/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.NavigableSet;
import java.util.Set;
import org.gradle.execution.taskgraph.WorkInfo;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public abstract class TaskInfo
extends WorkInfo {
    private final NavigableSet<WorkInfo> mustSuccessors = Sets.newTreeSet();
    private final NavigableSet<WorkInfo> shouldSuccessors = Sets.newTreeSet();
    private final NavigableSet<WorkInfo> finalizers = Sets.newTreeSet();
    private final NavigableSet<WorkInfo> finalizingSuccessors = Sets.newTreeSet();

    @Override
    public boolean allDependenciesComplete() {
        if (!super.allDependenciesComplete()) {
            return false;
        }
        for (WorkInfo dependency : this.mustSuccessors) {
            if (dependency.isComplete()) continue;
            return false;
        }
        for (WorkInfo dependency : this.finalizingSuccessors) {
            if (dependency.isComplete()) continue;
            return false;
        }
        return true;
    }

    public Set<WorkInfo> getMustSuccessors() {
        return this.mustSuccessors;
    }

    public Set<WorkInfo> getFinalizers() {
        return this.finalizers;
    }

    public Set<WorkInfo> getFinalizingSuccessors() {
        return this.finalizingSuccessors;
    }

    public Set<WorkInfo> getShouldSuccessors() {
        return this.shouldSuccessors;
    }

    protected void addMustSuccessor(WorkInfo toNode) {
        this.mustSuccessors.add(toNode);
    }

    protected void addFinalizingSuccessor(TaskInfo finalized) {
        this.finalizingSuccessors.add(finalized);
    }

    protected void addFinalizer(TaskInfo finalizerNode) {
        this.finalizers.add(finalizerNode);
        finalizerNode.addFinalizingSuccessor(this);
    }

    protected void addShouldSuccessor(WorkInfo toNode) {
        this.shouldSuccessors.add(toNode);
    }

    public void removeShouldSuccessor(TaskInfo toNode) {
        this.shouldSuccessors.remove(toNode);
    }

    @Override
    public Iterable<WorkInfo> getAllSuccessors() {
        return Iterables.concat(this.getMustSuccessors(), this.getFinalizingSuccessors(), super.getAllSuccessors());
    }

    @Override
    public Iterable<WorkInfo> getAllSuccessorsInReverseOrder() {
        return Iterables.concat(super.getAllSuccessorsInReverseOrder(), this.mustSuccessors.descendingSet(), this.finalizingSuccessors.descendingSet(), this.shouldSuccessors.descendingSet());
    }

    @Override
    public boolean hasHardSuccessor(WorkInfo successor) {
        if (super.hasHardSuccessor(successor)) {
            return true;
        }
        if (!(successor instanceof TaskInfo)) {
            return false;
        }
        return this.getMustSuccessors().contains(successor) || this.getFinalizingSuccessors().contains(successor);
    }
}

