/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Splitter;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.util.CollectionUtils;

public class BuildScriptBuilder {
    private final BuildInitDsl dsl;
    private final PathToFileResolver fileResolver;
    private final String fileNameWithoutExtension;
    private final List<String> headerLines = new ArrayList<String>();
    private final ListMultimap<String, DepSpec> dependencies = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    private final Map<String, String> plugins = new LinkedHashMap<String, String>();
    private final List<ConfigSpec> configSpecs = new ArrayList<ConfigSpec>();
    private static final ConfigSelector NULL_SELECTOR = new ConfigSelector(){};

    public BuildScriptBuilder(BuildInitDsl dsl, PathToFileResolver fileResolver, String fileNameWithoutExtension) {
        this.dsl = dsl;
        this.fileResolver = fileResolver;
        this.fileNameWithoutExtension = fileNameWithoutExtension;
    }

    public BuildScriptBuilder fileComment(String comment) {
        this.headerLines.addAll(Splitter.on((String)"\n").splitToList((CharSequence)comment));
        return this;
    }

    public BuildScriptBuilder plugin(String comment, String pluginId) {
        this.plugins.put(pluginId, comment);
        return this;
    }

    public BuildScriptBuilder dependency(String configuration, String comment, String ... dependencies) {
        this.dependencies.put((Object)configuration, (Object)new DepSpec(comment, Arrays.asList(dependencies)));
        return this;
    }

    public BuildScriptBuilder compileDependency(String comment, String ... dependencies) {
        return this.dependency("compile", comment, dependencies);
    }

    public BuildScriptBuilder testCompileDependency(String comment, String ... dependencies) {
        return this.dependency("testCompile", comment, dependencies);
    }

    public BuildScriptBuilder testRuntimeDependency(String comment, String ... dependencies) {
        return this.dependency("testRuntime", comment, dependencies);
    }

    public BuildScriptBuilder propertyAssignment(String comment, String propertyName, Object propertyValue) {
        return this.configuration(NULL_SELECTOR, new PropertyAssignment(comment, propertyName, propertyValue));
    }

    public BuildScriptBuilder taskMethodInvocation(String comment, String taskName, String taskType, String methodName) {
        return this.configuration(new TaskSelector(taskName, taskType), new MethodInvocation(comment, methodName));
    }

    public BuildScriptBuilder taskPropertyAssignment(String comment, String taskName, String taskType, String propertyName, Object propertyValue) {
        return this.configuration(new TaskSelector(taskName, taskType), new PropertyAssignment(comment, propertyName, propertyValue));
    }

    public BuildScriptBuilder conventionPropertyAssignment(String comment, String conventionName, String propertyName, Object propertyValue) {
        return this.configuration(new ConventionSelector(conventionName), new PropertyAssignment(comment, propertyName, propertyValue));
    }

    private BuildScriptBuilder configuration(ConfigSelector selector, ConfigExpression expression) {
        this.configSpecs.add(new ConfigSpec(selector, expression));
        return this;
    }

    public TemplateOperation create() {
        return new TemplateOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generate() {
                File target = BuildScriptBuilder.this.getTargetFile();
                try (PrintWriter writer = new PrintWriter(new FileWriter(target));){
                    PrettyPrinter printer = BuildScriptBuilder.prettyPrinterFor(BuildScriptBuilder.this.dsl, writer);
                    printer.printFileHeader(BuildScriptBuilder.this.headerLines);
                    printer.printPlugins(BuildScriptBuilder.this.plugins);
                    printer.printConfigSpecs(BuildScriptBuilder.this.configSpecs);
                    if (!BuildScriptBuilder.this.dependencies.isEmpty()) {
                        printer.printDependencies((ListMultimap<String, DepSpec>)BuildScriptBuilder.this.dependencies);
                        printer.printRepositories();
                    }
                }
                catch (Exception e) {
                    throw new GradleException("Could not generate file " + target + ".", e);
                }
            }
        };
    }

    private File getTargetFile() {
        return this.fileResolver.resolve(this.dsl.fileNameFor(this.fileNameWithoutExtension));
    }

    private static PrettyPrinter prettyPrinterFor(BuildInitDsl dsl, PrintWriter writer) {
        return new PrettyPrinter(BuildScriptBuilder.syntaxFor(dsl), writer);
    }

    private static Syntax syntaxFor(BuildInitDsl dsl) {
        switch (dsl) {
            case KOTLIN: {
                return new KotlinSyntax();
            }
            case GROOVY: {
                return new GroovySyntax();
            }
        }
        throw new IllegalStateException();
    }

    private static final class GroovySyntax
    implements Syntax {
        private GroovySyntax() {
        }

        @Override
        public String pluginDependencySpec(String pluginId) {
            return "id '" + pluginId + "'";
        }

        @Override
        public String dependencySpec(String config, String notation) {
            return config + " '" + notation + "'";
        }

        @Override
        public String propertyAssignment(PropertyAssignment expression) {
            String propertyName = expression.propertyName;
            Object propertyValue = expression.propertyValue;
            if (propertyValue instanceof CharSequence) {
                return propertyName + " = '" + propertyValue + "'";
            }
            return propertyName + " = " + propertyValue;
        }

        @Override
        public String conventionSelector(ConventionSelector selector) {
            return null;
        }

        @Override
        public String taskSelector(TaskSelector selector) {
            return selector.taskName;
        }
    }

    private static final class KotlinSyntax
    implements Syntax {
        private KotlinSyntax() {
        }

        @Override
        public String pluginDependencySpec(String pluginId) {
            return pluginId.matches("[a-z]+") ? pluginId : "`" + pluginId + "`";
        }

        @Override
        public String dependencySpec(String config, String notation) {
            return config + "(\"" + notation + "\")";
        }

        @Override
        public String propertyAssignment(PropertyAssignment expression) {
            String propertyName = expression.propertyName;
            Object propertyValue = expression.propertyValue;
            if (propertyValue instanceof Boolean) {
                return this.booleanPropertyNameFor(propertyName) + " = " + propertyValue;
            }
            if (propertyValue instanceof CharSequence) {
                return propertyName + " = \"" + propertyValue + '\"';
            }
            return propertyName + " = " + propertyValue;
        }

        private String booleanPropertyNameFor(String propertyName) {
            return "is" + StringUtils.capitalize((String)propertyName);
        }

        @Override
        public String conventionSelector(ConventionSelector selector) {
            return selector.conventionName;
        }

        @Override
        public String taskSelector(TaskSelector selector) {
            return "val " + selector.taskName + " by tasks.getting(" + selector.taskType + "::class)";
        }
    }

    private static interface Syntax {
        public String pluginDependencySpec(String var1);

        public String dependencySpec(String var1, String var2);

        public String propertyAssignment(PropertyAssignment var1);

        @Nullable
        public String conventionSelector(ConventionSelector var1);

        public String taskSelector(TaskSelector var1);
    }

    private static final class PrettyPrinter {
        private final Syntax syntax;
        private final PrintWriter writer;

        PrettyPrinter(Syntax syntax, PrintWriter writer) {
            this.syntax = syntax;
            this.writer = writer;
        }

        public void printFileHeader(Collection<String> lines) {
            this.println("/*");
            this.println(" * This file was generated by the Gradle 'init' task.");
            if (!lines.isEmpty()) {
                this.println(" *");
                for (String headerLine : lines) {
                    this.println(" * " + headerLine);
                }
            }
            this.println(" */");
        }

        public void printPlugins(Map<String, String> plugins) {
            if (plugins.isEmpty()) {
                return;
            }
            this.println();
            this.println("plugins {");
            Iterator<Map.Entry<String, String>> it = plugins.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String pluginId = entry.getKey();
                String comment = entry.getValue();
                this.println("    // " + comment);
                this.println("    " + this.pluginDependencySpec(pluginId));
                if (!it.hasNext()) continue;
                this.println();
            }
            this.println("}");
        }

        public void printRepositories() {
            this.println();
            this.println("// In this section you declare where to find the dependencies of your project");
            this.println("repositories {");
            this.println("    // Use jcenter for resolving your dependencies.");
            this.println("    // You can declare any Maven/Ivy/file repository here.");
            this.println("    jcenter()");
            this.println("}");
        }

        public void printDependencies(ListMultimap<String, DepSpec> dependencies) {
            this.println();
            this.println("dependencies {");
            boolean firstDep = true;
            for (String config : dependencies.keySet()) {
                for (DepSpec depSpec : dependencies.get((Object)config)) {
                    firstDep = this.printNewLineExceptTheFirstTime(firstDep);
                    this.println("    // " + depSpec.comment);
                    for (String dep : depSpec.deps) {
                        this.println("    " + this.dependencySpec(config, dep));
                    }
                }
            }
            this.println("}");
        }

        public void printConfigSpecs(List<ConfigSpec> configSpecs) {
            if (configSpecs.isEmpty()) {
                return;
            }
            for (ConfigGroup group : this.sortedConfigGroups(configSpecs)) {
                this.println();
                this.printConfigGroup(group);
            }
        }

        private void printConfigGroup(ConfigGroup configGroup) {
            String blockSelector = this.codeBlockSelectorFor(configGroup.selector);
            if (blockSelector != null) {
                this.println(blockSelector + " {");
                this.println();
            }
            String indent = blockSelector != null ? "    " : "";
            boolean firstExpression = true;
            for (ConfigExpression expression : configGroup.expressions) {
                firstExpression = this.printNewLineExceptTheFirstTime(firstExpression);
                this.printExpression(indent, expression);
            }
            if (blockSelector != null) {
                this.println("}");
            }
        }

        private List<ConfigGroup> sortedConfigGroups(List<ConfigSpec> configSpecs) {
            List<ConfigGroup> configGroups = this.configGroupsFrom(this.groupBySelector(configSpecs));
            Collections.sort(configGroups);
            return configGroups;
        }

        private List<ConfigGroup> configGroupsFrom(Map<ConfigSelector, Collection<ConfigSpec>> groupedConfigSpecs) {
            ArrayList<ConfigGroup> result = new ArrayList<ConfigGroup>(groupedConfigSpecs.size());
            for (Map.Entry<ConfigSelector, Collection<ConfigSpec>> group : groupedConfigSpecs.entrySet()) {
                ConfigSelector selector = group.getKey();
                Collection<ConfigSpec> specs = group.getValue();
                result.add(new ConfigGroup(selector, this.expressionsOf(specs)));
            }
            return result;
        }

        private List<ConfigExpression> expressionsOf(Collection<ConfigSpec> specs) {
            return CollectionUtils.collect(specs, new Transformer<ConfigExpression, ConfigSpec>(){

                @Override
                public ConfigExpression transform(ConfigSpec configSpec) {
                    return configSpec.expression;
                }
            });
        }

        private Map<ConfigSelector, Collection<ConfigSpec>> groupBySelector(List<ConfigSpec> configSpecs) {
            return CollectionUtils.groupBy(configSpecs, new Transformer<ConfigSelector, ConfigSpec>(){

                @Override
                public ConfigSelector transform(ConfigSpec configSpec) {
                    return configSpec.selector;
                }
            });
        }

        private boolean printNewLineExceptTheFirstTime(boolean firstTime) {
            if (!firstTime) {
                this.println();
            }
            return false;
        }

        private void printExpression(String indent, ConfigExpression expression) {
            if (expression.comment != null) {
                this.println(indent + "// " + expression.comment);
            }
            this.println(indent + this.codeFor(expression));
        }

        @Nullable
        private String codeBlockSelectorFor(ConfigSelector selector) {
            if (NULL_SELECTOR == selector) {
                return null;
            }
            if (selector instanceof TaskSelector) {
                return this.taskSelector((TaskSelector)selector);
            }
            if (selector instanceof ConventionSelector) {
                return this.conventionSelector((ConventionSelector)selector);
            }
            throw new IllegalStateException();
        }

        String codeFor(ConfigExpression expression) {
            if (expression instanceof MethodInvocation) {
                return this.methodInvocation((MethodInvocation)expression);
            }
            if (expression instanceof PropertyAssignment) {
                return this.propertyAssignment((PropertyAssignment)expression);
            }
            throw new IllegalStateException();
        }

        private String methodInvocation(MethodInvocation expression) {
            return expression.methodName + "()";
        }

        @Nullable
        private String conventionSelector(ConventionSelector selector) {
            return this.syntax.conventionSelector(selector);
        }

        private String taskSelector(TaskSelector selector) {
            return this.syntax.taskSelector(selector);
        }

        private String propertyAssignment(PropertyAssignment expression) {
            return this.syntax.propertyAssignment(expression);
        }

        private String dependencySpec(String config, String notation) {
            return this.syntax.dependencySpec(config, notation);
        }

        private String pluginDependencySpec(String pluginId) {
            return this.syntax.pluginDependencySpec(pluginId);
        }

        private void println(String s) {
            this.writer.println(s);
        }

        private void println() {
            this.writer.println();
        }

        private static class ConfigGroup
        implements Comparable<ConfigGroup> {
            final ConfigSelector selector;
            final List<ConfigExpression> expressions;

            ConfigGroup(ConfigSelector selector, List<ConfigExpression> expressions) {
                this.selector = selector;
                this.expressions = expressions;
            }

            @Override
            public int compareTo(ConfigGroup that) {
                return this.compareSelectors(this.selector, that.selector);
            }

            private int compareSelectors(ConfigSelector s1, ConfigSelector s2) {
                if (NULL_SELECTOR == s1) {
                    return -1;
                }
                if (NULL_SELECTOR == s2) {
                    return 1;
                }
                if (s1 instanceof ConventionSelector) {
                    if (s2 instanceof ConventionSelector) {
                        return this.conventionNameOf(s1).compareTo(this.conventionNameOf(s2));
                    }
                    return -1;
                }
                if (s1 instanceof TaskSelector) {
                    if (s2 instanceof TaskSelector) {
                        return this.taskNameOf(s1).compareTo(this.taskNameOf(s2));
                    }
                    return 1;
                }
                throw new IllegalStateException();
            }

            private String conventionNameOf(ConfigSelector selector) {
                return ((ConventionSelector)selector).conventionName;
            }

            private String taskNameOf(ConfigSelector selector) {
                return ((TaskSelector)selector).taskName;
            }
        }
    }

    private static class PropertyAssignment
    extends ConfigExpression {
        final String propertyName;
        final Object propertyValue;

        private PropertyAssignment(String comment, String propertyName, Object propertyValue) {
            super(comment);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }
    }

    private static class MethodInvocation
    extends ConfigExpression {
        final String methodName;

        private MethodInvocation(String comment, String methodName) {
            super(comment);
            this.methodName = methodName;
        }
    }

    private static abstract class ConfigExpression {
        final String comment;

        ConfigExpression(@Nullable String comment) {
            this.comment = comment;
        }
    }

    private static class ConventionSelector
    implements ConfigSelector {
        final String conventionName;

        private ConventionSelector(String conventionName) {
            this.conventionName = conventionName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConventionSelector that = (ConventionSelector)o;
            return Objects.equal((Object)this.conventionName, (Object)that.conventionName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.conventionName});
        }
    }

    private static class TaskSelector
    implements ConfigSelector {
        final String taskName;
        final String taskType;

        private TaskSelector(String taskName, String taskType) {
            this.taskName = taskName;
            this.taskType = taskType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskSelector that = (TaskSelector)o;
            return Objects.equal((Object)this.taskName, (Object)that.taskName) && Objects.equal((Object)this.taskType, (Object)that.taskType);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.taskName, this.taskType});
        }
    }

    private static interface ConfigSelector {
    }

    private static class ConfigSpec {
        final ConfigSelector selector;
        final ConfigExpression expression;

        ConfigSpec(ConfigSelector selector, ConfigExpression expression) {
            this.selector = selector;
            this.expression = expression;
        }
    }

    private static class DepSpec {
        final String comment;
        final List<String> deps;

        DepSpec(String comment, List<String> deps) {
            this.comment = comment;
            this.deps = deps;
        }
    }
}

