/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.archive;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Transformer;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparator;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcomeAssociation;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcomeComparisonResult;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntry;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntryComparison;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.FileToArchiveEntrySetTransformer;
import org.gradle.internal.Pair;
import org.gradle.util.CollectionUtils;

public class GeneratedArchiveBuildOutcomeComparator
implements BuildOutcomeComparator<GeneratedArchiveBuildOutcome, GeneratedArchiveBuildOutcomeComparisonResult> {
    private final Transformer<Set<ArchiveEntry>, File> archiveToEntriesTransformer;

    public GeneratedArchiveBuildOutcomeComparator() {
        this(new FileToArchiveEntrySetTransformer());
    }

    GeneratedArchiveBuildOutcomeComparator(Transformer<Set<ArchiveEntry>, File> archiveToEntriesTransformer) {
        this.archiveToEntriesTransformer = archiveToEntriesTransformer;
    }

    @Override
    public Class<GeneratedArchiveBuildOutcome> getComparedType() {
        return GeneratedArchiveBuildOutcome.class;
    }

    @Override
    public GeneratedArchiveBuildOutcomeComparisonResult compare(BuildOutcomeAssociation<GeneratedArchiveBuildOutcome> association) {
        GeneratedArchiveBuildOutcome source = association.getSource();
        GeneratedArchiveBuildOutcome target = association.getTarget();
        Set<Object> sourceEntries = source.getArchiveFile() != null && source.getArchiveFile().exists() ? this.archiveToEntriesTransformer.transform(source.getArchiveFile()) : Collections.emptySet();
        Set<Object> targetEntries = target.getArchiveFile() != null && target.getArchiveFile().exists() ? this.archiveToEntriesTransformer.transform(target.getArchiveFile()) : Collections.emptySet();
        CollectionUtils.SetDiff<ArchiveEntry> diff = CollectionUtils.diffSetsBy(sourceEntries, targetEntries, new Transformer<ArchiveEntry.Path, ArchiveEntry>(){

            @Override
            public ArchiveEntry.Path transform(ArchiveEntry entry) {
                return entry.getPath();
            }
        });
        TreeSet<ArchiveEntryComparison> entryComparisons = new TreeSet<ArchiveEntryComparison>();
        for (ArchiveEntry archiveEntry : diff.leftOnly) {
            entryComparisons.add(new ArchiveEntryComparison(archiveEntry, null));
        }
        for (Pair pair : diff.common) {
            entryComparisons.add(new ArchiveEntryComparison((ArchiveEntry)pair.left, (ArchiveEntry)pair.right));
        }
        for (ArchiveEntry archiveEntry : diff.rightOnly) {
            entryComparisons.add(new ArchiveEntryComparison(null, archiveEntry));
        }
        return new GeneratedArchiveBuildOutcomeComparisonResult(association, entryComparisons);
    }
}

