/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.InterningStringSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;

public class ClasspathEntrySnapshotDataSerializer
extends AbstractSerializer<ClasspathEntrySnapshotData> {
    private final MapSerializer<String, HashCode> mapSerializer;
    private final Serializer<ClassSetAnalysisData> analysisSerializer;
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

    public ClasspathEntrySnapshotDataSerializer(StringInterner interner) {
        this.mapSerializer = new MapSerializer<String, HashCode>(new InterningStringSerializer(interner), this.hashCodeSerializer);
        this.analysisSerializer = new ClassSetAnalysisData.Serializer(interner);
    }

    @Override
    public ClasspathEntrySnapshotData read(Decoder decoder) throws Exception {
        HashCode hash = this.hashCodeSerializer.read(decoder);
        Object hashes = this.mapSerializer.read(decoder);
        ClassSetAnalysisData data = this.analysisSerializer.read(decoder);
        return new ClasspathEntrySnapshotData(hash, (Map<String, HashCode>)hashes, data);
    }

    @Override
    public void write(Encoder encoder, ClasspathEntrySnapshotData value) throws Exception {
        this.hashCodeSerializer.write(encoder, value.getHash());
        this.mapSerializer.write(encoder, value.getHashes());
        this.analysisSerializer.write(encoder, value.getClassAnalysis());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ClasspathEntrySnapshotDataSerializer rhs = (ClasspathEntrySnapshotDataSerializer)obj;
        return Objects.equal(this.mapSerializer, rhs.mapSerializer) && Objects.equal(this.analysisSerializer, rhs.analysisSerializer) && Objects.equal((Object)this.hashCodeSerializer, (Object)rhs.hashCodeSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mapSerializer, this.analysisSerializer, this.hashCodeSerializer});
    }
}

