/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.StaleClassCleaner;

public abstract class CleaningJavaCompilerSupport<T extends JavaCompileSpec>
implements Compiler<T> {
    @Override
    public WorkResult execute(T spec) {
        StaleClassCleaner cleaner = this.createCleaner(spec);
        this.addDirectory(cleaner, spec.getDestinationDir());
        MinimalJavaCompileOptions compileOptions = spec.getCompileOptions();
        this.addDirectory(cleaner, compileOptions.getAnnotationProcessorGeneratedSourcesDirectory());
        this.addDirectory(cleaner, compileOptions.getHeaderOutputDirectory());
        cleaner.execute();
        Compiler<T> compiler = this.getCompiler();
        return compiler.execute(spec);
    }

    private void addDirectory(StaleClassCleaner cleaner, File dir) {
        if (dir != null) {
            cleaner.addDirToClean(dir);
        }
    }

    protected abstract Compiler<T> getCompiler();

    protected abstract StaleClassCleaner createCleaner(T var1);
}

