/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.AbstractGithubUrlGroupingAction;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.pullrequest.GithubPullRequestsToolWindowManager;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/GithubViewPullRequestsAction;", "Lorg/jetbrains/plugins/github/AbstractGithubUrlGroupingAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "remoteUrl", "", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "intellij.vcs.github"})
public final class GithubViewPullRequestsAction
extends AbstractGithubUrlGroupingAction {
    @Override
    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        Intrinsics.checkParameterIsNotNull((Object)remoteUrl, (String)"remoteUrl");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        GithubFullPath fullPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (fullPath == null) {
            GithubNotifications.showError(project, "Invalid GitHub Repository URL", remoteUrl + " is not a GitHub repository.");
            return;
        }
        boolean $i$f$service = false;
        Object object = ServiceManager.getService(GithubApiRequestExecutorManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        GithubApiRequestExecutor.WithTokenAuth withTokenAuth = ((GithubApiRequestExecutorManager)object).getExecutor(account, project);
        if (withTokenAuth == null) {
            return;
        }
        GithubApiRequestExecutor.WithTokenAuth requestExecutor = withTokenAuth;
        boolean $i$f$service2 = false;
        Object object2 = ServiceManager.getService(GithubAccountInformationProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"ServiceManager.getService(T::class.java)");
        GithubAccountInformationProvider accountInformationProvider = (GithubAccountInformationProvider)object2;
        Project $receiver$iv = project;
        boolean $i$f$service3 = false;
        Object object3 = ServiceManager.getService((Project)$receiver$iv, GithubPullRequestsToolWindowManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"ServiceManager.getService(this, T::class.java)");
        GithubPullRequestsToolWindowManager toolWindowManager = (GithubPullRequestsToolWindowManager)object3;
        if (toolWindowManager.showPullRequestsTabIfExists(repository, remote, remoteUrl, account)) {
            return;
        }
        new Task.Backgroundable(accountInformationProvider, requestExecutor, account, fullPath, toolWindowManager, repository, remote, remoteUrl, project, project, "Loading GitHub Repository Information", true, PerformInBackgroundOption.DEAF){
            @NotNull
            public GithubAuthenticatedUser accountDetails;
            @NotNull
            public GithubRepoDetailed repoDetails;
            final /* synthetic */ GithubAccountInformationProvider $accountInformationProvider;
            final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $requestExecutor;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GithubFullPath $fullPath;
            final /* synthetic */ GithubPullRequestsToolWindowManager $toolWindowManager;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitRemote $remote;
            final /* synthetic */ String $remoteUrl;
            final /* synthetic */ Project $project;

            @NotNull
            public final GithubAuthenticatedUser getAccountDetails() {
                GithubAuthenticatedUser githubAuthenticatedUser = this.accountDetails;
                if (githubAuthenticatedUser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"accountDetails");
                }
                return githubAuthenticatedUser;
            }

            public final void setAccountDetails(@NotNull GithubAuthenticatedUser githubAuthenticatedUser) {
                Intrinsics.checkParameterIsNotNull((Object)githubAuthenticatedUser, (String)"<set-?>");
                this.accountDetails = githubAuthenticatedUser;
            }

            @NotNull
            public final GithubRepoDetailed getRepoDetails() {
                GithubRepoDetailed githubRepoDetailed = this.repoDetails;
                if (githubRepoDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoDetails");
                }
                return githubRepoDetailed;
            }

            public final void setRepoDetails(@NotNull GithubRepoDetailed githubRepoDetailed) {
                Intrinsics.checkParameterIsNotNull((Object)githubRepoDetailed, (String)"<set-?>");
                this.repoDetails = githubRepoDetailed;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setText("Loading account information");
                this.accountDetails = this.$accountInformationProvider.getInformation(this.$requestExecutor, indicator, this.$account);
                indicator.setText("Loading repository information");
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
                String string = this.$fullPath.getUser();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fullPath.user");
                String string2 = this.$fullPath.getRepository();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fullPath.repository");
                GithubRepoDetailed githubRepoDetailed = this.$requestExecutor.execute(indicator, GithubApiRequests.Repos.get(githubServerPath, string, string2));
                if (githubRepoDetailed == null) {
                    throw (Throwable)new IllegalArgumentException("Repository " + this.$fullPath + " does not exist at " + this.$account.getServer() + " or you don't have access.");
                }
                this.repoDetails = githubRepoDetailed;
                indicator.checkCanceled();
            }

            public void onSuccess() {
                GithubApiRequestExecutor githubApiRequestExecutor = this.$requestExecutor;
                GithubAuthenticatedUser githubAuthenticatedUser = this.accountDetails;
                if (githubAuthenticatedUser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"accountDetails");
                }
                GithubRepoDetailed githubRepoDetailed = this.repoDetails;
                if (githubRepoDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoDetails");
                }
                this.$toolWindowManager.createPullRequestsTab(githubApiRequestExecutor, this.$repository, this.$remote, this.$remoteUrl, githubAuthenticatedUser, githubRepoDetailed, this.$account);
                this.$toolWindowManager.showPullRequestsTabIfExists(this.$repository, this.$remote, this.$remoteUrl, this.$account);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubNotifications.showError(this.$project, "Failed To Load Repository Information", error);
            }
            {
                this.$accountInformationProvider = $captured_local_variable$0;
                this.$requestExecutor = $captured_local_variable$1;
                this.$account = $captured_local_variable$2;
                this.$fullPath = $captured_local_variable$3;
                this.$toolWindowManager = $captured_local_variable$4;
                this.$repository = $captured_local_variable$5;
                this.$remote = $captured_local_variable$6;
                this.$remoteUrl = $captured_local_variable$7;
                this.$project = $captured_local_variable$8;
                super($super_call_param$9, $super_call_param$10, $super_call_param$11, $super_call_param$12);
            }
        }.queue();
    }

    public GithubViewPullRequestsAction() {
        super("View Pull Requests", null, AllIcons.Vcs.Vendors.Github);
    }
}

