/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.SupportCode;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditor;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroComponentProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.StringRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class IntroStringProperty
extends IntrospectedProperty<StringDescriptor> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.propertyInspector.IntroStringProperty");
    @NonNls
    private static final String CLIENT_PROP_NAME_2_DESCRIPTOR = "name2descriptor";
    private final StringRenderer myRenderer;
    private StringEditor myEditor;
    private final Project myProject;

    public IntroStringProperty(String name, Method readMethod, Method writeMethod, Project project, boolean storeAsClient) {
        super(name, readMethod, writeMethod, storeAsClient);
        this.myProject = project;
        this.myRenderer = new StringRenderer();
    }

    @Override
    @NotNull
    public PropertyRenderer<StringDescriptor> getRenderer() {
        StringRenderer stringRenderer = this.myRenderer;
        if (stringRenderer == null) {
            IntroStringProperty.$$$reportNull$$$0(0);
        }
        return stringRenderer;
    }

    @Override
    public PropertyEditor<StringDescriptor> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new StringEditor(this.myProject, this);
        }
        return this.myEditor;
    }

    @NotNull
    private static HashMap<String, StringDescriptor> getName2Descriptor(RadComponent component) {
        HashMap<String, StringDescriptor> name2Descriptor = (HashMap<String, StringDescriptor>)component.getClientProperty(CLIENT_PROP_NAME_2_DESCRIPTOR);
        if (name2Descriptor == null) {
            name2Descriptor = new HashMap<String, StringDescriptor>();
            component.putClientProperty(CLIENT_PROP_NAME_2_DESCRIPTOR, name2Descriptor);
        }
        HashMap<String, StringDescriptor> hashMap = name2Descriptor;
        if (hashMap == null) {
            IntroStringProperty.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static String mergeTextAndMnemonic(String text, int mnemonic, int mnemonicIndex) {
        if (text == null) {
            text = "";
        }
        int index = mnemonicIndex >= 0 && mnemonicIndex < text.length() && Character.toUpperCase(text.charAt(mnemonicIndex)) == mnemonic ? mnemonicIndex : -1;
        StringBuilder buffer = new StringBuilder(text);
        if (index != -1) {
            buffer.insert(index, '&');
            for (int i = buffer.length() - 1; i >= 0; --i) {
                if (buffer.charAt(i) != '&' || i == index) continue;
                buffer.insert(i, '&');
            }
        }
        return buffer.toString();
    }

    @Override
    public StringDescriptor getValue(RadComponent component) {
        StringDescriptor descriptor = IntroStringProperty.getName2Descriptor(component).get(this.getName());
        if (descriptor != null) {
            return descriptor;
        }
        JComponent delegee = component.getDelegee();
        return this.stringDescriptorFromValue(component, delegee);
    }

    private StringDescriptor stringDescriptorFromValue(RadComponent component, JComponent delegee) {
        StringDescriptor result;
        if ("text".equals(this.getName()) && delegee instanceof JLabel) {
            JLabel label = (JLabel)delegee;
            result = StringDescriptor.create((String)IntroStringProperty.mergeTextAndMnemonic(label.getText(), label.getDisplayedMnemonic(), label.getDisplayedMnemonicIndex()));
        } else if ("text".equals(this.getName()) && delegee instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)delegee;
            result = StringDescriptor.create((String)IntroStringProperty.mergeTextAndMnemonic(button.getText(), button.getMnemonic(), button.getDisplayedMnemonicIndex()));
        } else if (component != null) {
            result = StringDescriptor.create((String)((String)this.invokeGetter(component)));
        } else {
            try {
                result = StringDescriptor.create((String)((String)this.myReadMethod.invoke((Object)delegee, EMPTY_OBJECT_ARRAY)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (result != null) {
            result.setResolvedValue(result.getValue());
        }
        return result;
    }

    @Override
    protected void setValueImpl(RadComponent component, StringDescriptor value) throws Exception {
        String resolvedValue;
        RadRootContainer root;
        if (value == null || value.getBundleName() == null && !value.isNoI18n()) {
            IntroStringProperty.getName2Descriptor(component).remove(this.getName());
        } else {
            IntroStringProperty.getName2Descriptor(component).put(this.getName(), value);
        }
        JComponent delegee = component.getDelegee();
        Locale locale = (Locale)component.getClientProperty("LoadTimeLocaleKey");
        if (locale == null && (root = (RadRootContainer)FormEditingUtil.getRoot(component)) != null) {
            locale = root.getStringDescriptorLocale();
        }
        String string = resolvedValue = value != null && value.getValue() != null ? value.getValue() : StringDescriptorManager.getInstance(component.getModule()).resolve(value, locale);
        if (value != null) {
            value.setResolvedValue(resolvedValue);
        }
        if ("text".equals(this.getName())) {
            SupportCode.TextWithMnemonic textWithMnemonic = SupportCode.parseText((String)resolvedValue);
            if (delegee instanceof JLabel) {
                JLabel label = (JLabel)delegee;
                label.setText(textWithMnemonic.myText);
                if (textWithMnemonic.myMnemonicIndex != -1) {
                    label.setDisplayedMnemonic(textWithMnemonic.getMnemonicChar());
                    label.setDisplayedMnemonicIndex(textWithMnemonic.myMnemonicIndex);
                } else {
                    label.setDisplayedMnemonic(0);
                }
            } else if (delegee instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)delegee;
                button.setText(textWithMnemonic.myText);
                if (textWithMnemonic.myMnemonicIndex != -1) {
                    button.setMnemonic(textWithMnemonic.getMnemonicChar());
                    button.setDisplayedMnemonicIndex(textWithMnemonic.myMnemonicIndex);
                } else {
                    button.setMnemonic(0);
                }
            } else {
                this.invokeSetter(component, resolvedValue);
            }
            IntroStringProperty.checkUpdateBindingFromText(component, value, textWithMnemonic);
        } else {
            this.invokeSetter(component, resolvedValue);
        }
    }

    private static void checkUpdateBindingFromText(RadComponent component, StringDescriptor value, SupportCode.TextWithMnemonic textWithMnemonic) {
        RadRootContainer root;
        Locale locale;
        if (component.isLoadingProperties()) {
            return;
        }
        if (value.getValue() == null && (locale = (root = (RadRootContainer)FormEditingUtil.getRoot(component)).getStringDescriptorLocale()) != null && locale.getDisplayName().length() > 0) {
            return;
        }
        BindingProperty.checkCreateBindingFromText(component, textWithMnemonic.myText);
        if (component.getDelegee() instanceof JLabel) {
            for (IProperty prop : component.getModifiedProperties()) {
                if (!prop.getName().equals("labelFor") || !(prop instanceof IntroComponentProperty)) continue;
                ((IntroComponentProperty)prop).updateLabelForBinding(component);
            }
        }
    }

    public boolean refreshValue(RadComponent component) {
        StringDescriptor descriptor = this.getValue(component);
        if (descriptor.getValue() != null) {
            return false;
        }
        String oldResolvedValue = descriptor.getResolvedValue();
        descriptor.setResolvedValue(null);
        try {
            this.setValueImpl(component, descriptor);
            return !Comparing.equal((String)oldResolvedValue, (String)descriptor.getResolvedValue());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    @Override
    public void write(@NotNull StringDescriptor value, XmlWriter writer) {
        if (value == null) {
            IntroStringProperty.$$$reportNull$$$0(2);
        }
        writer.writeStringDescriptor(value, "value", "resource-bundle", "key");
    }

    @Override
    public void importSnapshotValue(SnapshotContext context, JComponent component, RadComponent radComponent) {
        try {
            Object value = this.myReadMethod.invoke((Object)component, EMPTY_OBJECT_ARRAY);
            if (value != null) {
                this.setValue(radComponent, this.stringDescriptorFromValue(null, component));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/properties/IntroStringProperty";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName2Descriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/properties/IntroStringProperty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

