/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FormReferencesSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        SearchScope userScope;
        if (p == null) {
            FormReferencesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            FormReferencesSearcher.$$$reportNull$$$0(1);
        }
        if (!FormReferencesSearcher.scopeCanContainForms(userScope = p.getScopeDeterminedByUser())) {
            return true;
        }
        PsiElement refElement = p.getElementToSearch();
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
            if (!refElement.isValid()) {
                return null;
            }
            return refElement.getContainingFile();
        });
        if (psiFile == null) {
            return true;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        GlobalSearchScope[] scope = new GlobalSearchScope[1];
        Project project = (Project)ReadAction.compute(() -> {
            Project project1 = psiFile.getProject();
            Module module = ProjectRootManager.getInstance((Project)project1).getFileIndex().getModuleForFile(virtualFile);
            if (module != null) {
                scope[0] = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
            }
            return project1;
        });
        if (scope[0] == null) {
            return true;
        }
        LocalSearchScope filterScope = userScope instanceof LocalSearchScope ? (LocalSearchScope)userScope : null;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return refElement instanceof PsiPackage || !(refElement instanceof PsiClass ? !FormReferencesSearcher.processReferencesInUIForms(consumer, psiManager, (PsiClass)refElement, scope[0], filterScope) : (refElement instanceof PsiEnumConstant ? !FormReferencesSearcher.processEnumReferencesInUIForms(consumer, psiManager, (PsiEnumConstant)refElement, scope[0], filterScope) : (refElement instanceof PsiField ? !FormReferencesSearcher.processReferencesInUIForms(consumer, psiManager, (PsiField)refElement, scope[0], filterScope) : (refElement instanceof IProperty ? !FormReferencesSearcher.processReferencesInUIForms(consumer, psiManager, (Property)refElement, scope[0], filterScope) : refElement instanceof PropertiesFile && !FormReferencesSearcher.processReferencesInUIForms(consumer, psiManager, (PropertiesFile)refElement, scope[0], filterScope)))));
    }

    private static boolean scopeCanContainForms(SearchScope scope) {
        PsiElement[] elements;
        if (!(scope instanceof LocalSearchScope)) {
            return true;
        }
        LocalSearchScope localSearchScope = (LocalSearchScope)scope;
        for (PsiElement element : elements = localSearchScope.getScope()) {
            if (element instanceof PsiDirectory) {
                return true;
            }
            boolean isForm = (Boolean)ReadAction.compute(() -> {
                PsiFile file;
                if (element instanceof PsiFile) {
                    file = (PsiFile)element;
                } else {
                    if (!element.isValid()) {
                        return false;
                    }
                    file = element.getContainingFile();
                }
                return file.getFileType() == StdFileTypes.GUI_DESIGNER_FORM;
            });
            if (!isForm) continue;
            return true;
        }
        return false;
    }

    private static boolean processReferencesInUIForms(Processor<? super PsiReference> processor, PsiManager psiManager, PsiClass aClass, GlobalSearchScope scope, LocalSearchScope filterScope) {
        String className = FormReferencesSearcher.getQualifiedName(aClass);
        return className == null || FormReferencesSearcher.processReferencesInUIFormsInner(className, (PsiElement)aClass, processor, scope, psiManager, filterScope);
    }

    public static String getQualifiedName(PsiClass aClass) {
        return (String)ReadAction.compute(() -> {
            if (!aClass.isValid()) {
                return null;
            }
            return aClass.getQualifiedName();
        });
    }

    private static boolean processEnumReferencesInUIForms(Processor<? super PsiReference> processor, PsiManager psiManager, PsiEnumConstant enumConstant, GlobalSearchScope scope, LocalSearchScope filterScope) {
        String className = (String)ReadAction.compute(() -> enumConstant.getName());
        return className == null || FormReferencesSearcher.processReferencesInUIFormsInner(className, (PsiElement)enumConstant, processor, scope, psiManager, filterScope);
    }

    private static boolean processReferencesInUIFormsInner(String name, PsiElement element, Processor<? super PsiReference> processor, GlobalSearchScope scope1, PsiManager manager, LocalSearchScope filterScope) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)manager.getProject()).intersectWith(scope1);
        List<PsiFile> files = FormClassIndex.findFormsBoundToClass(manager.getProject(), name, scope);
        return FormReferencesSearcher.processReferencesInFiles(files, manager, name, element, filterScope, processor);
    }

    private static boolean processReferencesInUIForms(Processor<? super PsiReference> processor, PsiManager psiManager, PsiField field, GlobalSearchScope scope1, LocalSearchScope filterScope) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)psiManager.getProject()).intersectWith(scope1);
        PsiClass containingClass = (PsiClass)ReadAction.compute(() -> field.getContainingClass());
        if (containingClass == null) {
            return true;
        }
        String fieldName = (String)ReadAction.compute(() -> field.getName());
        List<PsiFile> files = FormClassIndex.findFormsBoundToClass(psiManager.getProject(), containingClass, scope);
        return FormReferencesSearcher.processReferencesInFiles(files, psiManager, fieldName, (PsiElement)field, filterScope, processor);
    }

    private static boolean processReferences(Processor<? super PsiReference> processor, PsiFile file, String name, PsiElement element, LocalSearchScope filterScope) {
        CharSequence chars = (CharSequence)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            if (filterScope != null) {
                boolean isInScope = false;
                for (PsiElement filterElement : filterScope.getScope()) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)filterElement, (PsiElement)file, (boolean)false)) continue;
                    isInScope = true;
                    break;
                }
                if (!isInScope) {
                    return null;
                }
            }
            return file.getViewProvider().getContents();
        }));
        if (chars == null) {
            return true;
        }
        int index = 0;
        int offset = name.lastIndexOf(46);
        while ((index = CharArrayUtil.indexOf((CharSequence)chars, (CharSequence)name, (int)index)) >= 0) {
            int finalIndex = index++;
            Boolean searchDone = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
                PsiReference ref = file.findReferenceAt(finalIndex + offset + 1);
                if (ref != null && ref.isReferenceTo(element)) {
                    return processor.process((Object)ref);
                }
                return true;
            }));
            if (searchDone.booleanValue()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIForms(Processor<? super PsiReference> processor, PsiManager psiManager, Property property, GlobalSearchScope globalSearchScope, LocalSearchScope filterScope) {
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project).intersectWith(globalSearchScope);
        String name = (String)ReadAction.compute(() -> property.getName());
        if (name == null) {
            return true;
        }
        psiManager.startBatchFilesProcessingMode();
        try {
            CommonProcessors.CollectProcessor<VirtualFile> collector = new CommonProcessors.CollectProcessor<VirtualFile>(){

                protected boolean accept(VirtualFile virtualFile) {
                    return virtualFile.getFileType() == StdFileTypes.GUI_DESIGNER_FORM;
                }
            };
            ((PsiSearchHelperImpl)PsiSearchHelper.getInstance((Project)project)).processFilesWithText(scope, (short)16, true, name, (Processor)collector);
            for (VirtualFile vfile : collector.getResults()) {
                ProgressManager.checkCanceled();
                PsiFile file = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(vfile));
                if (FormReferencesSearcher.processReferences(processor, file, name, (PsiElement)property, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
        return true;
    }

    private static boolean processReferencesInUIForms(Processor<? super PsiReference> processor, PsiManager psiManager, PropertiesFile propFile, GlobalSearchScope globalSearchScope, LocalSearchScope filterScope) {
        Project project = psiManager.getProject();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project).intersectWith(globalSearchScope);
        String baseName = (String)ReadAction.compute(() -> propFile.getResourceBundle().getBaseName());
        PsiFile containingFile = (PsiFile)ReadAction.compute(() -> propFile.getContainingFile());
        List<PsiFile> files = Arrays.asList(CacheManager.SERVICE.getInstance((Project)project).getFilesWithWord(baseName, (short)16, scope, true));
        return FormReferencesSearcher.processReferencesInFiles(files, psiManager, baseName, (PsiElement)containingFile, filterScope, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInFiles(List<PsiFile> files, PsiManager psiManager, String baseName, PsiElement element, LocalSearchScope filterScope, Processor<? super PsiReference> processor) {
        psiManager.startBatchFilesProcessingMode();
        try {
            for (PsiFile file : files) {
                ProgressManager.checkCanceled();
                if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
                if (FormReferencesSearcher.processReferences(processor, file, baseName, element, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "p";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/uiDesigner/binding/FormReferencesSearcher";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

