/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.actions.UngroupButtonsAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.properties.IdentifierValidator;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;

public class GroupButtonsAction
extends AbstractGuiEditorAction {
    @Override
    protected void actionPerformed(GuiEditor editor, List<? extends RadComponent> selection, AnActionEvent e) {
        GroupButtonsAction.groupButtons(editor, selection);
    }

    public static void groupButtons(GuiEditor editor, List<? extends RadComponent> selectedComponents) {
        if (!editor.ensureEditable()) {
            return;
        }
        String groupName = Messages.showInputDialog((Project)editor.getProject(), (String)UIDesignerBundle.message("group.buttons.name.prompt", new Object[0]), (String)UIDesignerBundle.message("group.buttons.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)editor.getRootContainer().suggestGroupName(), (InputValidator)new IdentifierValidator(editor.getProject()));
        if (groupName == null) {
            return;
        }
        RadRootContainer rootContainer = editor.getRootContainer();
        RadButtonGroup group = rootContainer.createGroup(groupName);
        for (RadComponent radComponent : selectedComponents) {
            rootContainer.setGroupForComponent(radComponent, group);
        }
        editor.refreshAndSave(true);
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<? extends RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            GroupButtonsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setVisible(GroupButtonsAction.allButtons(selection));
        e.getPresentation().setEnabled(GroupButtonsAction.allButtons(selection) && selection.size() >= 2 && !UngroupButtonsAction.isSameGroup(editor, selection));
    }

    public static boolean allButtons(List<? extends RadComponent> selection) {
        for (RadComponent radComponent : selection) {
            if (radComponent.getDelegee() instanceof AbstractButton && !(radComponent.getDelegee() instanceof JButton)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/actions/GroupButtonsAction", "update"));
    }
}

