/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationException;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationType;
import org.jetbrains.jps.intellilang.instrumentation.PatternInstrumenter;
import org.jetbrains.jps.intellilang.model.JpsIntelliLangConfiguration;
import org.jetbrains.jps.intellilang.model.JpsIntelliLangExtensionService;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class PatternValidatorBuilder
extends BaseInstrumentingBuilder {
    @NotNull
    public String getPresentableName() {
        if ("IntelliLang Pattern Validator" == null) {
            PatternValidatorBuilder.$$$reportNull$$$0(0);
        }
        return "IntelliLang Pattern Validator";
    }

    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        JpsGlobal project = context.getProjectDescriptor().getModel().getGlobal();
        JpsIntelliLangConfiguration config = JpsIntelliLangExtensionService.getInstance().getConfiguration(project);
        return config.getInstrumentationType() != InstrumentationType.NONE;
    }

    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return !"module-info".equals(compiledClass.getClassName());
    }

    @Nullable
    protected BinaryContent instrument(CompileContext context, CompiledClass compiled, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        JpsGlobal project = context.getProjectDescriptor().getModel().getGlobal();
        JpsIntelliLangConfiguration config = JpsIntelliLangExtensionService.getInstance().getConfiguration(project);
        try {
            boolean instrumented = PatternValidatorBuilder.processClassFile(reader, writer, finder, config.getPatternAnnotationClass(), config.getInstrumentationType());
            if (instrumented) {
                return new BinaryContent(writer.toByteArray());
            }
        }
        catch (InstrumentationException e) {
            context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, e.getMessage()));
        }
        return null;
    }

    protected String getProgressMessage() {
        return "Adding pattern assertions...";
    }

    public static boolean processClassFile(ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder, String annotationClassName, InstrumentationType type) {
        PatternInstrumenter instrumenter = new PatternInstrumenter(annotationClassName, (ClassVisitor)writer, type, finder);
        reader.accept((ClassVisitor)instrumenter, 0);
        return instrumenter.instrumented();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/intellilang/instrumentation/PatternValidatorBuilder", "getPresentableName"));
    }
}

