/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

public class KotlinFunctionIntrinsic
extends FunctionIntrinsicWithReceiverComputed {
    @NotNull
    private final String functionName;
    private final JsExpression[] additionalArguments;

    public KotlinFunctionIntrinsic(@NotNull String functionName, JsExpression ... additionalArguments) {
        this.functionName = functionName;
        this.additionalArguments = additionalArguments;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver2, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
        JsNameRef function2 = JsAstUtils.pureFqn(this.functionName, (JsExpression)Namer.kotlinObject());
        if (this.additionalArguments.length > 0) {
            ArrayList<? extends JsExpression> newArguments = new ArrayList<JsExpression>(arguments2);
            for (JsExpression e : this.additionalArguments) {
                newArguments.add(e.deepCopy());
            }
            arguments2 = newArguments;
        }
        return new JsInvocation((JsExpression)function2, receiver2 == null ? arguments2 : TranslationUtils.generateInvocationArguments(receiver2, arguments2));
    }
}

