/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;

public class TabledDescriptorRenderer {
    protected final List<TableOrTextRenderer> renderers = Lists.newArrayList();

    public TabledDescriptorRenderer text(@NotNull TextRenderer textRenderer) {
        this.renderers.add(textRenderer);
        return this;
    }

    public TabledDescriptorRenderer table(@NotNull TableRenderer tableRenderer) {
        this.renderers.add(tableRenderer);
        return this;
    }

    public static TextRenderer newText() {
        return new TextRenderer();
    }

    public static TableRenderer newTable() {
        return new TableRenderer();
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (TableOrTextRenderer tableOrTextRenderer : this.renderers) {
            if (tableOrTextRenderer instanceof TableRenderer) {
                this.renderTable((TableRenderer)tableOrTextRenderer, result2);
                continue;
            }
            this.renderText((TextRenderer)tableOrTextRenderer, result2);
        }
        return result2.toString();
    }

    @NotNull
    public DiagnosticParameterRenderer<KotlinType> getTypeRenderer() {
        return Renderers.RENDER_TYPE;
    }

    protected void renderText(TextRenderer textRenderer, StringBuilder result2) {
        for (TextRenderer.TextElement element : textRenderer.elements) {
            result2.append(element.text);
        }
    }

    protected void renderTable(TableRenderer table, StringBuilder result2) {
        if (table.rows.isEmpty()) {
            return;
        }
        RenderingContext context = TabledDescriptorRenderer.computeRenderingContext(table);
        for (TableRenderer.TableRow row : table.rows) {
            if (row instanceof TextRenderer) {
                this.renderText((TextRenderer)row, result2);
            }
            if (row instanceof TableRenderer.DescriptorRow) {
                result2.append(Renderers.COMPACT.render(((TableRenderer.DescriptorRow)row).descriptor, context));
            }
            if (row instanceof TableRenderer.FunctionArgumentsRow) {
                TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, result2, context);
            }
            result2.append("\n");
        }
    }

    private void renderFunctionArguments(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes2, StringBuilder result2, @NotNull RenderingContext context) {
        boolean hasReceiver;
        boolean bl = hasReceiver = receiverType != null;
        if (hasReceiver) {
            result2.append("receiver: ");
            result2.append(this.getTypeRenderer().render(receiverType, context));
            result2.append("  arguments: ");
        }
        if (argumentTypes2.isEmpty()) {
            result2.append("()");
            return;
        }
        result2.append("(");
        Iterator<KotlinType> iterator2 = argumentTypes2.iterator();
        while (iterator2.hasNext()) {
            KotlinType argumentType = iterator2.next();
            if (argumentType == null) {
                result2.append("<unknown>");
            } else {
                String renderedArgument = this.getTypeRenderer().render(argumentType, context);
                result2.append(renderedArgument);
            }
            if (!iterator2.hasNext()) continue;
            result2.append(",");
        }
        result2.append(")");
    }

    public static TabledDescriptorRenderer create() {
        return new TabledDescriptorRenderer();
    }

    @NotNull
    protected static RenderingContext computeRenderingContext(@NotNull TableRenderer table) {
        ArrayList<Annotated> toRender = new ArrayList<Annotated>();
        for (TableRenderer.TableRow row : table.rows) {
            if (row instanceof TableRenderer.DescriptorRow) {
                toRender.add(((TableRenderer.DescriptorRow)row).descriptor);
                continue;
            }
            if (row instanceof TableRenderer.FunctionArgumentsRow) {
                toRender.add(((TableRenderer.FunctionArgumentsRow)row).receiverType);
                toRender.addAll(((TableRenderer.FunctionArgumentsRow)row).argumentTypes);
                continue;
            }
            if (!(row instanceof TextRenderer)) {
                throw new AssertionError((Object)("Unknown row of type " + row.getClass()));
            }
        }
        return new RenderingContext.Impl(toRender);
    }

    public static enum TextElementType {
        STRONG,
        ERROR,
        DEFAULT;

    }

    public static class TextRenderer
    implements TableOrTextRenderer,
    TableRenderer.TableRow {
        public final List<TextElement> elements = Lists.newArrayList();

        public TextRenderer normal(@NotNull Object text2) {
            this.elements.add(new TextElement(TextElementType.DEFAULT, text2.toString()));
            return this;
        }

        public TextRenderer error(@NotNull Object text2) {
            this.elements.add(new TextElement(TextElementType.ERROR, text2.toString()));
            return this;
        }

        public TextRenderer strong(@NotNull Object text2) {
            this.elements.add(new TextElement(TextElementType.STRONG, text2.toString()));
            return this;
        }

        public static class TextElement {
            public TextElementType type;
            public String text;

            public TextElement(@NotNull TextElementType type2, @NotNull String text2) {
                this.type = type2;
                this.text = text2;
            }
        }
    }

    public static class TableRenderer
    implements TableOrTextRenderer {
        public final List<TableRow> rows = Lists.newArrayList();

        public TableRenderer descriptor(CallableDescriptor descriptor2) {
            this.rows.add(new DescriptorRow(descriptor2));
            return this;
        }

        public TableRenderer functionArgumentTypeList(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes2) {
            return this.functionArgumentTypeList(receiverType, argumentTypes2, position -> false);
        }

        public TableRenderer functionArgumentTypeList(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes2, @NotNull Predicate<ConstraintPosition> isErrorPosition) {
            this.rows.add(new FunctionArgumentsRow(receiverType, argumentTypes2, isErrorPosition));
            return this;
        }

        public TableRenderer text(@NotNull String text2) {
            this.rows.add(TabledDescriptorRenderer.newText().normal(text2));
            return this;
        }

        public TableRenderer text(@NotNull TextRenderer textRenderer) {
            this.rows.add(textRenderer);
            return this;
        }

        public static class FunctionArgumentsRow
        implements TableRow {
            public final KotlinType receiverType;
            public final List<KotlinType> argumentTypes;
            public final Predicate<ConstraintPosition> isErrorPosition;

            public FunctionArgumentsRow(KotlinType receiverType, List<KotlinType> argumentTypes2, Predicate<ConstraintPosition> isErrorPosition) {
                this.receiverType = receiverType;
                this.argumentTypes = argumentTypes2;
                this.isErrorPosition = isErrorPosition;
            }
        }

        public static class DescriptorRow
        implements TableRow {
            public final CallableDescriptor descriptor;

            public DescriptorRow(CallableDescriptor descriptor2) {
                this.descriptor = descriptor2;
            }
        }

        public static interface TableRow {
        }
    }

    public static interface TableOrTextRenderer {
    }
}

