/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;

public class SourceToOutputMappingImpl
implements SourceToOutputMapping {
    private final OneToManyPathsMapping myMapping;

    public SourceToOutputMappingImpl(File storePath) throws IOException {
        this.myMapping = new OneToManyPathsMapping(storePath);
    }

    @Override
    public void setOutputs(@NotNull String srcPath, @NotNull Collection<String> outputs) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(0);
        }
        if (outputs == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(1);
        }
        this.myMapping.update(srcPath, outputs);
    }

    @Override
    public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(2);
        }
        if (outputPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(3);
        }
        this.myMapping.update(srcPath, outputPath);
    }

    @Override
    public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(4);
        }
        if (outputPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(5);
        }
        this.myMapping.appendData(srcPath, outputPath);
    }

    @Override
    public void remove(@NotNull String srcPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(6);
        }
        this.myMapping.remove(srcPath);
    }

    @Override
    public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) throws IOException {
        if (sourcePath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(7);
        }
        if (outputPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(8);
        }
        this.myMapping.removeData(sourcePath, outputPath);
    }

    @Override
    @NotNull
    public Collection<String> getSources() throws IOException {
        Collection<String> collection = this.myMapping.getKeys();
        if (collection == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Override
    @Nullable
    public Collection<String> getOutputs(@NotNull String srcPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(10);
        }
        return this.myMapping.getState(srcPath);
    }

    @Override
    @NotNull
    public Iterator<String> getSourcesIterator() throws IOException {
        Iterator<String> iterator = this.myMapping.getKeysIterator();
        if (iterator == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(11);
        }
        return iterator;
    }

    public void flush(boolean memoryCachesOnly) {
        this.myMapping.flush(memoryCachesOnly);
    }

    public void close() throws IOException {
        this.myMapping.close();
    }

    public void clean() throws IOException {
        this.myMapping.clean();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputs";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setOutputs";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setOutput";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendOutput";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeOutput";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOutputs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

