/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.storage.BuildTargetStorages;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetRegistry;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingImpl;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class BuildDataManager
implements StorageOwner {
    private static final int VERSION = 39 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.storage.BuildDataManager");
    private static final String SRC_TO_FORM_STORAGE = "src-form";
    private static final String SRC_TO_OUTPUT_STORAGE = "src-out";
    private static final String OUT_TARGET_STORAGE = "out-target";
    private static final String MAPPINGS_STORAGE = "mappings";
    private static final int CONCURRENCY_LEVEL = BuildRunner.PARALLEL_BUILD_ENABLED ? IncProjectBuilder.MAX_BUILDER_THREADS : 1;
    private static final String SRC_TO_OUTPUT_FILE_NAME = "data";
    private final ConcurrentMap<BuildTarget<?>, AtomicNotNullLazyValue<SourceToOutputMappingImpl>> mySourceToOutputs = new ConcurrentHashMap(16, 0.75f, CONCURRENCY_LEVEL);
    private final ConcurrentMap<BuildTarget<?>, AtomicNotNullLazyValue<BuildTargetStorages>> myTargetStorages = new ConcurrentHashMap(16, 0.75f, CONCURRENCY_LEVEL);
    private final OneToManyPathsMapping mySrcToFormMap;
    private final Mappings myMappings;
    private final BuildDataPaths myDataPaths;
    private final BuildTargetsState myTargetsState;
    private final OutputToTargetRegistry myOutputToTargetRegistry;
    private final File myVersionFile;
    private final StorageOwner myTargetStoragesOwner = new CompositeStorageOwner(){

        @Override
        protected Iterable<? extends StorageOwner> getChildStorages() {
            return new Iterable<StorageOwner>(){

                @Override
                public Iterator<StorageOwner> iterator() {
                    final Iterator iterator = BuildDataManager.this.myTargetStorages.values().iterator();
                    return new Iterator<StorageOwner>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public StorageOwner next() {
                            return (StorageOwner)((AtomicNotNullLazyValue)iterator.next()).getValue();
                        }

                        @Override
                        public void remove() {
                            iterator.remove();
                        }
                    };
                }
            };
        }
    };
    private final LazyValueFactory<BuildTarget<?>, SourceToOutputMappingImpl> SOURCE_OUTPUT_MAPPING_VALUE_FACTORY = new LazyValueFactory<BuildTarget<?>, SourceToOutputMappingImpl>(){

        @Override
        public AtomicNotNullLazyValue<SourceToOutputMappingImpl> create(final BuildTarget<?> key) {
            return new AtomicNotNullLazyValue<SourceToOutputMappingImpl>(){

                @NotNull
                protected SourceToOutputMappingImpl compute() {
                    SourceToOutputMappingImpl sourceToOutputMappingImpl;
                    block2: {
                        try {
                            sourceToOutputMappingImpl = new SourceToOutputMappingImpl(new File(BuildDataManager.this.getSourceToOutputMapRoot(key), BuildDataManager.SRC_TO_OUTPUT_FILE_NAME));
                            if (sourceToOutputMappingImpl != null) break block2;
                        }
                        catch (IOException e) {
                            throw new BuildDataCorruptedException(e);
                        }
                        1.$$$reportNull$$$0(0);
                    }
                    return sourceToOutputMappingImpl;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/storage/BuildDataManager$2$1", "compute"));
                }
            };
        }
    };
    private final LazyValueFactory<BuildTarget<?>, BuildTargetStorages> TARGET_STORAGES_VALUE_FACTORY = new LazyValueFactory<BuildTarget<?>, BuildTargetStorages>(){

        @Override
        public AtomicNotNullLazyValue<BuildTargetStorages> create(final BuildTarget<?> target) {
            return new AtomicNotNullLazyValue<BuildTargetStorages>(){

                @NotNull
                protected BuildTargetStorages compute() {
                    BuildTargetStorages buildTargetStorages = new BuildTargetStorages(target, BuildDataManager.this.myDataPaths);
                    if (buildTargetStorages == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return buildTargetStorages;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/storage/BuildDataManager$3$1", "compute"));
                }
            };
        }
    };
    private Boolean myVersionDiffers = null;

    public BuildDataManager(BuildDataPaths dataPaths, BuildTargetsState targetsState, boolean useMemoryTempCaches) throws IOException {
        this.myDataPaths = dataPaths;
        this.myTargetsState = targetsState;
        this.mySrcToFormMap = new OneToManyPathsMapping(new File(this.getSourceToFormsRoot(), SRC_TO_OUTPUT_FILE_NAME));
        this.myOutputToTargetRegistry = new OutputToTargetRegistry(new File(this.getOutputToSourceRegistryRoot(), SRC_TO_OUTPUT_FILE_NAME));
        this.myMappings = new Mappings(BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot()), useMemoryTempCaches);
        this.myVersionFile = new File(this.myDataPaths.getDataStorageRoot(), "version.dat");
    }

    public BuildTargetsState getTargetsState() {
        return this.myTargetsState;
    }

    public OutputToTargetRegistry getOutputToTargetRegistry() {
        return this.myOutputToTargetRegistry;
    }

    public SourceToOutputMapping getSourceToOutputMap(BuildTarget<?> target) throws IOException {
        SourceToOutputMappingImpl sourceToOutputMapping = BuildDataManager.fetchValue(this.mySourceToOutputs, target, this.SOURCE_OUTPUT_MAPPING_VALUE_FACTORY);
        int buildTargetId = this.myTargetsState.getBuildTargetId(target);
        return new SourceToOutputMappingWrapper(sourceToOutputMapping, buildTargetId);
    }

    public SourceToOutputMappingImpl createSourceToOutputMapForStaleTarget(BuildTargetType<?> targetType, String targetId) throws IOException {
        return new SourceToOutputMappingImpl(new File(this.getSourceToOutputMapRoot(targetType, targetId), SRC_TO_OUTPUT_FILE_NAME));
    }

    @NotNull
    public <S extends StorageOwner> S getStorage(@NotNull BuildTarget<?> target, @NotNull StorageProvider<S> provider) throws IOException {
        if (target == null) {
            BuildDataManager.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            BuildDataManager.$$$reportNull$$$0(1);
        }
        BuildTargetStorages storages = BuildDataManager.fetchValue(this.myTargetStorages, target, this.TARGET_STORAGES_VALUE_FACTORY);
        S s = storages.getOrCreateStorage(provider);
        if (s == null) {
            BuildDataManager.$$$reportNull$$$0(2);
        }
        return s;
    }

    public OneToManyPathsMapping getSourceToFormMap() {
        return this.mySrcToFormMap;
    }

    public Mappings getMappings() {
        return this.myMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTargetStorages(BuildTarget<?> target) throws IOException {
        try {
            AtomicNotNullLazyValue storages = (AtomicNotNullLazyValue)this.myTargetStorages.remove(target);
            if (storages != null) {
                ((BuildTargetStorages)storages.getValue()).close();
            }
        }
        finally {
            File[] targetData = this.myDataPaths.getTargetDataRoot(target).listFiles();
            if (targetData != null) {
                File srcOutputMapRoot = this.getSourceToOutputMapRoot(target);
                for (File dataFile : targetData) {
                    if (FileUtil.filesEqual((File)dataFile, (File)srcOutputMapRoot)) continue;
                    FileUtil.delete((File)dataFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() throws IOException {
        try {
            this.myTargetStoragesOwner.clean();
            this.myTargetStorages.clear();
        }
        finally {
            try {
                this.closeSourceToOutputStorages();
            }
            finally {
                try {
                    BuildDataManager.wipeStorage(this.getSourceToFormsRoot(), this.mySrcToFormMap);
                }
                finally {
                    try {
                        BuildDataManager.wipeStorage(this.getOutputToSourceRegistryRoot(), this.myOutputToTargetRegistry);
                    }
                    finally {
                        Mappings mappings = this.myMappings;
                        if (mappings != null) {
                            Mappings mappings2 = mappings;
                            synchronized (mappings2) {
                                mappings.clean();
                            }
                        } else {
                            FileUtil.delete((File)BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot()));
                        }
                    }
                }
            }
            this.myTargetsState.clean();
        }
        this.saveVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean memoryCachesOnly) {
        this.myTargetStoragesOwner.flush(memoryCachesOnly);
        for (AtomicNotNullLazyValue mapping : this.mySourceToOutputs.values()) {
            ((SourceToOutputMappingImpl)mapping.getValue()).flush(memoryCachesOnly);
        }
        this.myOutputToTargetRegistry.flush(memoryCachesOnly);
        this.mySrcToFormMap.flush(memoryCachesOnly);
        Mappings mappings = this.myMappings;
        if (mappings != null) {
            Mappings mappings2 = mappings;
            synchronized (mappings2) {
                mappings.flush(memoryCachesOnly);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.myTargetsState.save();
            try {
                this.myTargetStoragesOwner.close();
            }
            finally {
                this.myTargetStorages.clear();
            }
        }
        finally {
            try {
                this.closeSourceToOutputStorages();
            }
            finally {
                try {
                    this.myOutputToTargetRegistry.close();
                }
                finally {
                    try {
                        BuildDataManager.closeStorage(this.mySrcToFormMap);
                    }
                    finally {
                        Mappings mappings = this.myMappings;
                        if (mappings != null) {
                            try {
                                mappings.close();
                            }
                            catch (BuildDataCorruptedException e) {
                                throw e.getCause();
                            }
                        }
                    }
                }
            }
        }
    }

    public void closeSourceToOutputStorages(Collection<BuildTargetChunk> chunks) throws IOException {
        for (BuildTargetChunk chunk : chunks) {
            for (BuildTarget<?> target : chunk.getTargets()) {
                AtomicNotNullLazyValue mapping = (AtomicNotNullLazyValue)this.mySourceToOutputs.remove(target);
                if (mapping == null) continue;
                ((SourceToOutputMappingImpl)mapping.getValue()).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSourceToOutputStorages() throws IOException {
        IOException ex = null;
        try {
            for (AtomicNotNullLazyValue lazy : this.mySourceToOutputs.values()) {
                try {
                    SourceToOutputMappingImpl mapping = (SourceToOutputMappingImpl)lazy.getValue();
                    try {
                        mapping.close();
                    }
                    catch (IOException e) {
                        if (ex != null) continue;
                        ex = e;
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.mySourceToOutputs.clear();
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static <K, V> V fetchValue(ConcurrentMap<K, AtomicNotNullLazyValue<V>> container, K key, LazyValueFactory<K, V> valueFactory) throws IOException {
        AtomicNotNullLazyValue<V> newValue;
        AtomicNotNullLazyValue<V> lazy = (AtomicNotNullLazyValue<V>)container.get(key);
        if (lazy == null && (lazy = container.putIfAbsent(key, newValue = valueFactory.create(key))) == null) {
            lazy = newValue;
        }
        try {
            return (V)lazy.getValue();
        }
        catch (BuildDataCorruptedException e) {
            throw e.getCause();
        }
    }

    private File getSourceToOutputMapRoot(BuildTarget<?> target) {
        return new File(this.myDataPaths.getTargetDataRoot(target), SRC_TO_OUTPUT_STORAGE);
    }

    private File getSourceToOutputMapRoot(BuildTargetType<?> targetType, String targetId) {
        return new File(this.myDataPaths.getTargetDataRoot(targetType, targetId), SRC_TO_OUTPUT_STORAGE);
    }

    private File getSourceToFormsRoot() {
        return new File(this.myDataPaths.getDataStorageRoot(), SRC_TO_FORM_STORAGE);
    }

    private File getOutputToSourceRegistryRoot() {
        return new File(this.myDataPaths.getDataStorageRoot(), OUT_TARGET_STORAGE);
    }

    public BuildDataPaths getDataPaths() {
        return this.myDataPaths;
    }

    public static File getMappingsRoot(File dataStorageRoot) {
        return new File(dataStorageRoot, MAPPINGS_STORAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wipeStorage(File root, @Nullable AbstractStateStorage<?, ?> storage) {
        if (storage != null) {
            AbstractStateStorage<?, ?> abstractStateStorage = storage;
            synchronized (abstractStateStorage) {
                storage.wipe();
            }
        } else {
            FileUtil.delete((File)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeStorage(@Nullable AbstractStateStorage<?, ?> storage) throws IOException {
        if (storage != null) {
            AbstractStateStorage<?, ?> abstractStateStorage = storage;
            synchronized (abstractStateStorage) {
                storage.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean versionDiffers() {
        Boolean cached = this.myVersionDiffers;
        if (cached != null) {
            return cached;
        }
        try (DataInputStream is = new DataInputStream(new FileInputStream(this.myVersionFile));){
            boolean diff = is.readInt() != VERSION;
            this.myVersionDiffers = diff;
            boolean bl = diff;
            return bl;
        }
        catch (FileNotFoundException ignored) {
            return false;
        }
        catch (IOException ex) {
            LOG.info((Throwable)ex);
            return true;
        }
    }

    public void saveVersion() {
        Boolean differs = this.myVersionDiffers;
        if (differs == null || differs.booleanValue()) {
            FileUtil.createIfDoesntExist((File)this.myVersionFile);
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(this.myVersionFile));){
                os.writeInt(VERSION);
                this.myVersionDiffers = Boolean.FALSE;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildDataManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStorage";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SourceToOutputMappingWrapper
    implements SourceToOutputMapping {
        private final SourceToOutputMapping myDelegate;
        private final int myBuildTargetId;

        SourceToOutputMappingWrapper(SourceToOutputMapping delegate, int buildTargetId) {
            this.myDelegate = delegate;
            this.myBuildTargetId = buildTargetId;
        }

        @Override
        public void setOutputs(@NotNull String srcPath, @NotNull Collection<String> outputs) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(0);
            }
            if (outputs == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(1);
            }
            try {
                this.myDelegate.setOutputs(srcPath, outputs);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputs, this.myBuildTargetId);
            }
        }

        @Override
        public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(2);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(3);
            }
            try {
                this.myDelegate.setOutput(srcPath, outputPath);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(4);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(5);
            }
            try {
                this.myDelegate.appendOutput(srcPath, outputPath);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void remove(@NotNull String srcPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(6);
            }
            this.myDelegate.remove(srcPath);
        }

        @Override
        public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) throws IOException {
            if (sourcePath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(7);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(8);
            }
            this.myDelegate.removeOutput(sourcePath, outputPath);
        }

        @Override
        @NotNull
        public Collection<String> getSources() throws IOException {
            Collection<String> collection = this.myDelegate.getSources();
            if (collection == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(9);
            }
            return collection;
        }

        @Override
        @Nullable
        public Collection<String> getOutputs(@NotNull String srcPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(10);
            }
            return this.myDelegate.getOutputs(srcPath);
        }

        @Override
        @NotNull
        public Iterator<String> getSourcesIterator() throws IOException {
            Iterator<String> iterator = this.myDelegate.getSourcesIterator();
            if (iterator == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(11);
            }
            return iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "srcPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputs";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputPath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePath";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager$SourceToOutputMappingWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildDataManager$SourceToOutputMappingWrapper";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSources";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourcesIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setOutputs";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setOutput";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "appendOutput";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeOutput";
                    break;
                }
                case 9: 
                case 11: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getOutputs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface LazyValueFactory<K, V> {
        public AtomicNotNullLazyValue<V> create(K var1);
    }
}

