/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.PsiElementPredicate;

class ReplaceAssignmentWithPostfixExpressionPredicate
implements PsiElementPredicate {
    ReplaceAssignmentWithPostfixExpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (!(strippedLhs instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)strippedLhs;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)target;
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression());
        if (!(rhs instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
        PsiExpression lOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
        PsiExpression rOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (ExpressionUtils.isLiteral((PsiElement)lOperand, 1)) {
            if (!ExpressionUtils.isReferenceTo(rOperand, variable)) {
                return false;
            }
            return JavaTokenType.PLUS.equals(tokenType);
        }
        if (ExpressionUtils.isLiteral((PsiElement)rOperand, 1)) {
            if (!ExpressionUtils.isReferenceTo(lOperand, variable)) {
                return false;
            }
            return JavaTokenType.PLUS.equals(tokenType) || JavaTokenType.MINUS.equals(tokenType);
        }
        return false;
    }
}

