/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodRefCanBeReplacedWithLambdaInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.ref.can.be.replaced.with.lambda.name", new Object[0]);
        if (string == null) {
            MethodRefCanBeReplacedWithLambdaInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            MethodRefCanBeReplacedWithLambdaInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodRefToLambdaVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)infos[0];
        boolean onTheFly = (Boolean)infos[1];
        if (LambdaRefactoringUtil.canConvertToLambdaWithoutSideEffects(methodReferenceExpression)) {
            return new MethodRefToLambdaFix();
        }
        if (onTheFly) {
            return new SideEffectsMethodRefToLambdaFix();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/MethodRefCanBeReplacedWithLambdaInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SideEffectsMethodRefToLambdaFix
    extends MethodRefToLambdaFix {
        private SideEffectsMethodRefToLambdaFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = ApplicationManager.getApplication().isUnitTestMode() ? super.getFamilyName() + " (side effects)" : super.getFamilyName();
            if (string == null) {
                SideEffectsMethodRefToLambdaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        protected void doFix(Project project, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            if (methodReferenceExpression == null) {
                SideEffectsMethodRefToLambdaFix.$$$reportNull$$$0(1);
            }
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
                if (editor != null) {
                    CommandProcessor.getInstance().executeCommand(project, () -> SideEffectsMethodRefToLambdaFix.doFixAndRemoveSideEffects(editor, methodReferenceExpression), this.getFamilyName(), null);
                }
            });
        }

        private static void doFixAndRemoveSideEffects(@NotNull Editor editor, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            if (editor == null) {
                SideEffectsMethodRefToLambdaFix.$$$reportNull$$$0(2);
            }
            if (methodReferenceExpression == null) {
                SideEffectsMethodRefToLambdaFix.$$$reportNull$$$0(3);
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{methodReferenceExpression})) {
                return;
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)WriteAction.compute(() -> LambdaRefactoringUtil.convertMethodReferenceToLambda(methodReferenceExpression, false, true));
            if (lambdaExpression != null) {
                LambdaRefactoringUtil.removeSideEffectsFromLambdaBody(editor, lambdaExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/MethodRefCanBeReplacedWithLambdaInspection$SideEffectsMethodRefToLambdaFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/MethodRefCanBeReplacedWithLambdaInspection$SideEffectsMethodRefToLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doFixAndRemoveSideEffects";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MethodRefToLambdaFix
    extends InspectionGadgetsFix {
        private MethodRefToLambdaFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("method.ref.can.be.replaced.with.lambda.quickfix", new Object[0]);
            if (string == null) {
                MethodRefToLambdaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiMethodReferenceExpression) {
                this.doFix(project, (PsiMethodReferenceExpression)element);
            }
        }

        protected void doFix(Project project, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            if (methodReferenceExpression == null) {
                MethodRefToLambdaFix.$$$reportNull$$$0(1);
            }
            LambdaRefactoringUtil.convertMethodReferenceToLambda(methodReferenceExpression, false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/MethodRefCanBeReplacedWithLambdaInspection$MethodRefToLambdaFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodReferenceExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/MethodRefCanBeReplacedWithLambdaInspection$MethodRefToLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MethodRefToLambdaVisitor
    extends BaseInspectionVisitor {
        private MethodRefToLambdaVisitor() {
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression methodReferenceExpression) {
            super.visitMethodReferenceExpression(methodReferenceExpression);
            if (LambdaRefactoringUtil.canConvertToLambda(methodReferenceExpression)) {
                this.registerError((PsiElement)methodReferenceExpression, methodReferenceExpression, this.isOnTheFly());
            }
        }
    }
}

