/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ObjectInstantiationInEqualsHashCodeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.instantiation.inside.equals.or.hashcode.display.name", new Object[0]);
        if (string == null) {
            ObjectInstantiationInEqualsHashCodeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)infos[0]), PsiMethod.class);
        assert (method != null);
        if (infos.length > 1) {
            String string = InspectionGadgetsBundle.message("object.instantiation.inside.equals.or.hashcode.problem.descriptor2", method.getName(), infos[1]);
            if (string == null) {
                ObjectInstantiationInEqualsHashCodeInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("object.instantiation.inside.equals.or.hashcode.problem.descriptor", method.getName());
        if (string == null) {
            ObjectInstantiationInEqualsHashCodeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectInstantiationInEqualsHashCodeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/ObjectInstantiationInEqualsHashCodeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ObjectInstantiationInEqualsHashCodeVisitor
    extends BaseInspectionVisitor {
        private ObjectInstantiationInEqualsHashCodeVisitor() {
        }

        public void visitExpression(PsiExpression expression2) {
            if (!ExpressionUtils.isAutoBoxed(expression2) || ObjectInstantiationInEqualsHashCodeVisitor.isAutoBoxingFromCache(expression2) || !ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression2)) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, false, true);
            if (TypeUtils.getType("java.lang.Boolean", (PsiElement)expression2).equals((Object)expectedType) || TypeUtils.getType("java.lang.Byte", (PsiElement)expression2).equals((Object)expectedType)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, "autoboxing");
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            PsiExpression iteratedValue2 = statement.getIteratedValue();
            if (iteratedValue2 == null || iteratedValue2.getType() instanceof PsiArrayType || !ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)statement)) {
                return;
            }
            this.registerError((PsiElement)iteratedValue2, iteratedValue2, "iterator");
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            List<StandardMethodContract> contracts2 = JavaMethodContractUtil.getMethodContracts(method);
            ContractReturnValue contractValue = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
            if (ContractReturnValue.returnNew().equals(contractValue)) {
                if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression2)) {
                    return;
                }
                this.registerMethodCallError(expression2, expression2);
            } else if (method.isVarArgs()) {
                if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression2)) {
                    return;
                }
                this.registerMethodCallError(expression2, expression2, "varargs call");
            } else {
                if (!"valueOf".equals(method.getName())) {
                    return;
                }
                PsiExpression[] expressions2 = expression2.getArgumentList().getExpressions();
                if (expressions2.length != 1) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String qualifiedName = aClass.getQualifiedName();
                if ("java.lang.Short".equals(qualifiedName) || "java.lang.Integer".equals(qualifiedName) || "java.lang.Long".equals(qualifiedName) || "java.lang.Character".equals(qualifiedName)) {
                    if (ObjectInstantiationInEqualsHashCodeVisitor.isAutoBoxingFromCache(expressions2[0]) || !ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression2)) {
                        return;
                    }
                    this.registerError((PsiElement)expression2, expression2);
                }
            }
        }

        private static boolean isAutoBoxingFromCache(PsiExpression expression2) {
            Character character;
            char c;
            Number number;
            int l;
            LongRangeSet range = CommonDataflow.getExpressionFact(expression2, DfaFactType.RANGE);
            if (range != null && !range.isEmpty() && range.min() >= -128L && range.max() <= 127L) {
                return true;
            }
            Object value2 = ExpressionUtils.computeConstantExpression(expression2);
            return value2 instanceof Number ? (l = (number = (Number)value2).intValue()) >= -128 && l <= 127 : value2 instanceof Character && (c = (character = (Character)value2).charValue()) <= '\u007f';
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            if (!(expression2.getParent() instanceof PsiVariable)) {
                return;
            }
            if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            if (!ExpressionUtils.hasStringType((PsiExpression)expression2) || ExpressionUtils.isEvaluatedAtCompileTime((PsiExpression)expression2)) {
                return;
            }
            if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression2)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }

        private static boolean isInsideEqualsOrHashCode(PsiElement element) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiAssertStatement.class, PsiThrowStatement.class});
            if (method == null) {
                return false;
            }
            return MethodUtils.isEquals(method) || MethodUtils.isHashCode(method) || MethodUtils.isCompareTo(method) || MethodUtils.isComparatorCompare(method);
        }
    }
}

