/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldStaticFinalFix;
import com.siyeh.ig.psiutils.LoggingUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NonStaticFinalLoggerInspection
extends BaseInspection {
    protected final List<String> loggerClassNames = new ArrayList<String>();
    public String loggerClassName = StringUtil.join(LoggingUtils.DEFAULT_LOGGERS, (String)",");

    public NonStaticFinalLoggerInspection() {
        NonStaticFinalLoggerInspection.parseString(this.loggerClassName, this.loggerClassNames);
    }

    public JComponent createOptionsPanel() {
        return UiUtils.createTreeClassChooserList(this.loggerClassNames, InspectionGadgetsBundle.message("logger.class.name", new Object[0]), InspectionGadgetsBundle.message("choose.logger.class", new Object[0]), new String[0]);
    }

    @NotNull
    public String getID() {
        if ("NonConstantLogger" == null) {
            NonStaticFinalLoggerInspection.$$$reportNull$$$0(0);
        }
        return "NonConstantLogger";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.constant.logger.display.name", new Object[0]);
        if (string == null) {
            NonStaticFinalLoggerInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.constant.logger.problem.descriptor", new Object[0]);
        if (string == null) {
            NonStaticFinalLoggerInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldStaticFinalFix.buildFixUnconditional(field);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            NonStaticFinalLoggerInspection.$$$reportNull$$$0(3);
        }
        super.readSettings(element);
        NonStaticFinalLoggerInspection.parseString(this.loggerClassName, this.loggerClassNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            NonStaticFinalLoggerInspection.$$$reportNull$$$0(4);
        }
        this.loggerClassName = NonStaticFinalLoggerInspection.formatString(this.loggerClassNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonStaticFinalLoggerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/logging/NonStaticFinalLoggerInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/logging/NonStaticFinalLoggerInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NonStaticFinalLoggerVisitor
    extends BaseInspectionVisitor {
        private NonStaticFinalLoggerVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField[] fields;
            if (aClass == null) {
                NonStaticFinalLoggerVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            for (PsiField field : fields = aClass.getFields()) {
                if (!this.isLogger((PsiVariable)field) || field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
                this.registerFieldError(field, field);
            }
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type2 = variable.getType();
            String text2 = type2.getCanonicalText();
            return NonStaticFinalLoggerInspection.this.loggerClassNames.contains(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/logging/NonStaticFinalLoggerInspection$NonStaticFinalLoggerVisitor", "visitClass"));
        }
    }
}

