/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionFromCatchWhichDoesntWrapInspection
extends BaseInspection {
    public boolean ignoreGetMessage;
    public boolean ignoreCantWrap;

    @NotNull
    public String getID() {
        if ("ThrowInsideCatchBlockWhichIgnoresCaughtException" == null) {
            ExceptionFromCatchWhichDoesntWrapInspection.$$$reportNull$$$0(0);
        }
        return "ThrowInsideCatchBlockWhichIgnoresCaughtException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("exception.from.catch.which.doesnt.wrap.display.name", new Object[0]);
        if (string == null) {
            ExceptionFromCatchWhichDoesntWrapInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("exception.from.catch.which.doesnt.wrap.problem.descriptor", new Object[0]);
        if (string == null) {
            ExceptionFromCatchWhichDoesntWrapInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("exception.from.catch.which.doesntwrap.ignore.option", new Object[0]), "ignoreGetMessage");
        panel.addCheckbox(InspectionGadgetsBundle.message("exception.from.catch.which.doesntwrap.ignore.cant.wrap.option", new Object[0]), "ignoreCantWrap");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExceptionFromCatchWhichDoesntWrapVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/ExceptionFromCatchWhichDoesntWrapInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ReferenceFinder
    extends JavaRecursiveElementVisitor {
        private final Set<PsiReferenceExpression> visited = new HashSet<PsiReferenceExpression>();
        private boolean argumentsContainCatchParameter;
        private final PsiParameter parameter;

        ReferenceFinder(PsiParameter parameter2) {
            this.parameter = parameter2;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement grandParent;
            PsiElement parent;
            if (this.argumentsContainCatchParameter || !this.visited.add(expression2)) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement target = expression2.resolve();
            if (!this.parameter.equals(target)) {
                if (target instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)target;
                    Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope(), (boolean)false);
                    query.forEach(reference -> {
                        PsiExpression[] arguments;
                        PsiElement element = reference.getElement();
                        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{PsiParenthesizedExpression.class});
                        if (!(parent instanceof PsiReferenceExpression)) {
                            return true;
                        }
                        PsiElement grandParent = parent.getParent();
                        if (!(grandParent instanceof PsiMethodCallExpression)) {
                            return true;
                        }
                        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                            argument.accept((PsiElementVisitor)this);
                        }
                        return true;
                    });
                    PsiExpression initializer = variable.getInitializer();
                    if (initializer != null) {
                        initializer.accept((PsiElementVisitor)this);
                    }
                }
                return;
            }
            if (!ExceptionFromCatchWhichDoesntWrapInspection.this.ignoreGetMessage && (parent = expression2.getParent()) instanceof PsiReferenceExpression && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression) {
                return;
            }
            this.argumentsContainCatchParameter = true;
        }

        boolean usesParameter() {
            return this.argumentsContainCatchParameter;
        }
    }

    private class ExceptionFromCatchWhichDoesntWrapVisitor
    extends BaseInspectionVisitor {
        private ExceptionFromCatchWhichDoesntWrapVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            PsiClassType classType;
            PsiClass exceptionClass;
            PsiType thrownType;
            super.visitThrowStatement(statement);
            PsiCatchSection catchSection = (PsiCatchSection)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiCatchSection.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (catchSection == null) {
                return;
            }
            PsiParameter parameter2 = catchSection.getParameter();
            if (parameter2 == null) {
                return;
            }
            String parameterName = parameter2.getName();
            if (PsiUtil.isIgnoredName((String)parameterName)) {
                return;
            }
            PsiExpression exception = statement.getException();
            if (exception == null) {
                return;
            }
            if (ExceptionFromCatchWhichDoesntWrapInspection.this.ignoreCantWrap && (thrownType = exception.getType()) instanceof PsiClassType && (exceptionClass = (classType = (PsiClassType)thrownType).resolve()) != null) {
                PsiMethod[] constructors = exceptionClass.getConstructors();
                PsiClassType throwableType = TypeUtils.getType("java.lang.Throwable", (PsiElement)statement);
                boolean canWrap = false;
                block0: for (PsiMethod constructor : constructors) {
                    PsiParameter[] parameters2;
                    PsiParameterList parameterList = constructor.getParameterList();
                    for (PsiParameter constructorParameter : parameters2 = parameterList.getParameters()) {
                        PsiType type2 = constructorParameter.getType();
                        if (!throwableType.equals((Object)type2)) continue;
                        canWrap = true;
                        break block0;
                    }
                }
                if (!canWrap) {
                    return;
                }
            }
            ReferenceFinder visitor = new ReferenceFinder(parameter2);
            exception.accept((PsiElementVisitor)visitor);
            if (visitor.usesParameter()) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

