/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.uast.UastVisitorAdapter;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.siyeh.InspectionGadgetsBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class SuspiciousPackagePrivateAccessInspection
extends AbstractBaseUastLocalInspectionTool {
    @XCollection
    public List<ModulesSet> MODULES_SETS_LOADED_TOGETHER = new ArrayList<ModulesSet>();
    private final AtomicClearableLazyValue<Map<String, ModulesSet>> myModuleSetByModuleName = AtomicClearableLazyValue.create(() -> {
        HashMap<String, ModulesSet> result = new HashMap<String, ModulesSet>();
        for (ModulesSet modulesSet : this.MODULES_SETS_LOADED_TOGETHER) {
            for (String module : modulesSet.modules) {
                result.put(module, modulesSet);
            }
        }
        return result;
    });

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(0);
        }
        UastVisitorAdapter uastVisitorAdapter = new UastVisitorAdapter(new AbstractUastNonRecursiveVisitor(){

            public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                UExpression receiver2 = node.getReceiver();
                if (node.getSourcePsi() instanceof PsiMethodCallExpression) {
                    return true;
                }
                PsiElement resolved = node.resolve();
                if (resolved instanceof PsiMember) {
                    this.checkAccess((UElement)node.getSelector(), (PsiMember)resolved, SuspiciousPackagePrivateAccessInspection.getAccessObjectType(receiver2));
                }
                return true;
            }

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                PsiElement resolved;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                UElement uastParent2 = node.getUastParent();
                if (!this.isSelectorOfQualifiedReference((UExpression)node) && !this.isReferenceToConstructorOrQualifiedMethodReference(node, uastParent2) && (resolved = node.resolve()) instanceof PsiMember) {
                    this.checkAccess((UElement)node, (PsiMember)resolved, null);
                }
                return true;
            }

            private boolean isReferenceToConstructorOrQualifiedMethodReference(@NotNull USimpleNameReferenceExpression node, @Nullable UElement uastParent2) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                return uastParent2 instanceof UCallExpression && this.isMethodReferenceOfCallExpression(node, (UCallExpression)uastParent2) && (((UCallExpression)uastParent2).getKind() == UastCallKind.CONSTRUCTOR_CALL || this.isSelectorOfQualifiedReference((UExpression)uastParent2));
            }

            private boolean isSelectorOfQualifiedReference(@Nullable UExpression expression2) {
                if (expression2 == null) {
                    return false;
                }
                UElement parent = expression2.getUastParent();
                return parent instanceof UQualifiedReferenceExpression && this.referToSameSourceElement((UElement)expression2, (UElement)((UQualifiedReferenceExpression)parent).getSelector());
            }

            private boolean isMethodReferenceOfCallExpression(@NotNull USimpleNameReferenceExpression expression2, @NotNull UCallExpression parent) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (parent == null) {
                    1.$$$reportNull$$$0(4);
                }
                UIdentifier methodIdentifier2 = parent.getMethodIdentifier();
                UReferenceExpression classReference2 = parent.getClassReference();
                if (methodIdentifier2 == null && classReference2 != null) {
                    methodIdentifier2 = classReference2.getReferenceNameElement();
                }
                return this.referToSameSourceElement(expression2.getReferenceNameElement(), (UElement)methodIdentifier2);
            }

            private boolean referToSameSourceElement(@Nullable UElement element1, @Nullable UElement element2) {
                if (element1 == null || element2 == null) {
                    return false;
                }
                PsiElement sourcePsi1 = element1.getSourcePsi();
                return sourcePsi1 != null && sourcePsi1.equals(element2.getSourcePsi());
            }

            public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                PsiElement resolve;
                if (node == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((resolve = node.resolve()) instanceof PsiMember) {
                    PsiMember member = (PsiMember)resolve;
                    UElement sourceNode = SuspiciousPackagePrivateAccessInspection.getReferenceNameElement(node);
                    if (sourceNode != null) {
                        this.checkAccess(sourceNode, member, SuspiciousPackagePrivateAccessInspection.getAccessObjectType(node.getQualifierExpression()));
                    }
                }
                return true;
            }

            public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                PsiClass resolved;
                if (node == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (!(node.getSourcePsi() instanceof PsiTypeElement) && (resolved = PsiTypesUtil.getPsiClass((PsiType)node.getType())) != null) {
                    this.checkAccess((UElement)node, (PsiMember)resolved, null);
                }
                return true;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!this.isSelectorOfQualifiedReference((UExpression)node) && node.getKind() == UastCallKind.CONSTRUCTOR_CALL) {
                    PsiMethod resolved = node.resolve();
                    if (resolved != null) {
                        this.checkAccess((UElement)node, (PsiMember)resolved, null);
                    } else {
                        PsiElement resolvedClass;
                        UReferenceExpression classReference2 = node.getClassReference();
                        PsiElement psiElement = resolvedClass = classReference2 != null ? classReference2.resolve() : null;
                        if (resolvedClass instanceof PsiClass) {
                            this.checkAccess((UElement)node, (PsiMember)((PsiClass)resolvedClass), null);
                        }
                    }
                }
                return true;
            }

            private void checkAccess(@NotNull UElement sourceNode, @NotNull PsiMember target, @Nullable PsiClass accessObjectType) {
                if (sourceNode == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (target == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (target.hasModifier(JvmModifier.PACKAGE_LOCAL)) {
                    this.checkPackageLocalAccess(sourceNode, target, "package-private");
                } else if (target.hasModifier(JvmModifier.PROTECTED) && !SuspiciousPackagePrivateAccessInspection.canAccessProtectedMember(sourceNode, target, accessObjectType)) {
                    this.checkPackageLocalAccess(sourceNode, target, "protected and used not through a subclass here");
                }
            }

            private void checkPackageLocalAccess(@NotNull UElement sourceNode, PsiMember targetElement, String accessType) {
                PsiElement sourcePsi;
                if (sourceNode == null) {
                    1.$$$reportNull$$$0(10);
                }
                if ((sourcePsi = sourceNode.getSourcePsi()) != null) {
                    Module targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)targetElement);
                    Module sourceModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
                    if (SuspiciousPackagePrivateAccessInspection.this.isPackageLocalAccessSuspicious(sourceModule, targetModule) && PsiTreeUtil.getParentOfType((PsiElement)sourcePsi, PsiComment.class) == null) {
                        List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)targetElement, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.PUBLIC, (boolean)true));
                        String elementDescription = StringUtil.removeHtmlTags((String)StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)targetElement, (boolean)true)));
                        holder.registerProblem(sourcePsi, elementDescription + " is " + accessType + ", but declared in a different module '" + targetModule.getName() + "'", IntentionWrapper.wrapToQuickFixes((IntentionAction[])fixes.toArray(IntentionAction.EMPTY_ARRAY), (PsiFile)targetElement.getContainingFile()));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 8: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceNode";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitQualifiedReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSimpleNameReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isReferenceToConstructorOrQualifiedMethodReference";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isMethodReferenceOfCallExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallableReferenceExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeReferenceExpression";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkAccess";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkPackageLocalAccess";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true);
        if (uastVisitorAdapter == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(1);
        }
        return uastVisitorAdapter;
    }

    @Nullable
    private static UElement getReferenceNameElement(UCallableReferenceExpression node) {
        PsiElement nameElement;
        PsiElement psi = node.getSourcePsi();
        if (psi instanceof PsiReferenceExpression && (nameElement = ((PsiReferenceExpression)psi).getReferenceNameElement()) != null) {
            return UastContextKt.toUElement((PsiElement)nameElement);
        }
        return node;
    }

    @Nullable
    private static PsiClass getAccessObjectType(@Nullable UExpression receiver2) {
        if (receiver2 == null || receiver2 instanceof UThisExpression || receiver2 instanceof USuperExpression) {
            return null;
        }
        PsiType type2 = receiver2.getExpressionType();
        if (type2 != null) {
            if (!(type2 instanceof PsiClassType)) {
                return null;
            }
            return ((PsiClassType)type2).resolve();
        }
        PsiElement element = ((UReferenceExpression)receiver2).resolve();
        return element instanceof PsiClass ? (PsiClass)element : null;
    }

    private static boolean canAccessProtectedMember(UElement sourceNode, PsiMember member, PsiClass accessObjectType) {
        PsiClass memberClass = member.getContainingClass();
        if (memberClass == null) {
            return false;
        }
        PsiElement sourcePsi = sourceNode.getSourcePsi();
        UClass sourceClass = (UClass)UastUtils.findContaining((PsiElement)sourcePsi, UClass.class);
        if (sourceClass == null) {
            return false;
        }
        return JavaResolveUtil.canAccessProtectedMember(member, memberClass, accessObjectType, sourceClass.getJavaPsi(), member.hasModifierProperty("static"));
    }

    private boolean isPackageLocalAccessSuspicious(Module sourceModule, Module targetModule) {
        if (targetModule == null || sourceModule == null || targetModule.equals(sourceModule)) {
            return false;
        }
        ModulesSet sourceGroup = (ModulesSet)((Map)this.myModuleSetByModuleName.getValue()).get(sourceModule.getName());
        ModulesSet targetGroup = (ModulesSet)((Map)this.myModuleSetByModuleName.getValue()).get(targetModule.getName());
        return sourceGroup == null || sourceGroup != targetGroup;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        final JBTextArea component = new JBTextArea();
        component.setText(this.MODULES_SETS_LOADED_TOGETHER.stream().map(it -> String.join((CharSequence)",", it.modules)).collect(Collectors.joining("\n")));
        component.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SuspiciousPackagePrivateAccessInspection.this.MODULES_SETS_LOADED_TOGETHER.clear();
                for (String line : StringUtil.splitByLines((String)component.getText())) {
                    ModulesSet set = new ModulesSet();
                    set.modules = new LinkedHashSet<String>(StringUtil.split((String)line, (String)","));
                    SuspiciousPackagePrivateAccessInspection.this.MODULES_SETS_LOADED_TOGETHER.add(set);
                }
                SuspiciousPackagePrivateAccessInspection.this.myModuleSetByModuleName.drop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection$2", "textChanged"));
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        JPanel labels2 = new JPanel(new FlowLayout(0));
        labels2.add((Component)new JBLabel(InspectionGadgetsBundle.message("groups.of.modules.loaded.together.label", new Object[0])));
        labels2.add((Component)ContextHelpLabel.create((String)InspectionGadgetsBundle.message("groups.of.modules.loaded.together.description", new Object[0])));
        panel.add((Component)labels2, "North");
        panel.add((Component)new JBScrollPane((Component)component), "Center");
        return panel;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(2);
        }
        super.readSettings(node);
        this.myModuleSetByModuleName.drop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="modules-set")
    public static class ModulesSet {
        @XCollection(elementName="module", valueAttributeName="name")
        @Property(surroundWithTag=false)
        public Set<String> modules = new LinkedHashSet<String>();
    }
}

