/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNotLastCaseInSwitchInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("default.not.last.case.in.switch.display.name", new Object[0]);
        if (string == null) {
            DefaultNotLastCaseInSwitchInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("default.not.last.case.in.switch.problem.descriptor", infos[1]);
        if (string == null) {
            DefaultNotLastCaseInSwitchInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiSwitchLabelStatementBase lbl = (PsiSwitchLabelStatementBase)infos[0];
        if (lbl instanceof PsiSwitchLabelStatement) {
            PsiElement lastDefaultStmt = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)lbl, PsiSwitchLabelStatementBase.class));
            if (!(lastDefaultStmt instanceof PsiBreakStatement)) {
                return null;
            }
            PsiSwitchLabelStatementBase prevLbl = (PsiSwitchLabelStatementBase)PsiTreeUtil.getPrevSiblingOfType((PsiElement)lbl, PsiSwitchLabelStatementBase.class);
            if (prevLbl != null && !(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lbl) instanceof PsiBreakStatement)) {
                return null;
            }
        }
        return new InspectionGadgetsFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) {
                PsiSwitchLabelStatementBase labelStatementBase = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiSwitchLabelStatementBase.class);
                if (labelStatementBase == null) {
                    return;
                }
                PsiSwitchBlock switchBlock = labelStatementBase.getEnclosingSwitchBlock();
                if (switchBlock == null) {
                    return;
                }
                PsiCodeBlock blockBody = switchBlock.getBody();
                if (blockBody == null) {
                    return;
                }
                PsiSwitchLabelStatementBase nextLabel = (PsiSwitchLabelStatementBase)PsiTreeUtil.getNextSiblingOfType((PsiElement)labelStatementBase, PsiSwitchLabelStatementBase.class);
                if (nextLabel != null) {
                    PsiElement lastStmtInDefaultCase = nextLabel.getPrevSibling();
                    blockBody.addRange((PsiElement)labelStatementBase, lastStmtInDefaultCase);
                    blockBody.deleteChildRange((PsiElement)labelStatementBase, lastStmtInDefaultCase);
                }
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                if ("Make 'default' the last case" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Make 'default' the last case";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DefaultNotLastCaseInSwitchInspection$1", "getFamilyName"));
            }
        };
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DefaultNotLastCaseInSwitchVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/DefaultNotLastCaseInSwitchInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DefaultNotLastCaseInSwitchVisitor
    extends BaseInspectionVisitor {
        private DefaultNotLastCaseInSwitchVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                DefaultNotLastCaseInSwitchVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            this.visitSwitchBlock((PsiSwitchBlock)statement, "statement");
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            super.visitSwitchExpression(expression2);
            this.visitSwitchBlock((PsiSwitchBlock)expression2, "expression");
        }

        private void visitSwitchBlock(@NotNull PsiSwitchBlock statement, String locationDescription) {
            PsiCodeBlock body2;
            if (statement == null) {
                DefaultNotLastCaseInSwitchVisitor.$$$reportNull$$$0(1);
            }
            if ((body2 = statement.getBody()) == null) {
                return;
            }
            PsiStatement[] statements = body2.getStatements();
            boolean labelSeen = false;
            for (int i = statements.length - 1; i >= 0; --i) {
                PsiStatement child = statements[i];
                if (!(child instanceof PsiSwitchLabelStatementBase)) continue;
                PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)child;
                if (label.isDefaultCase()) {
                    if (labelSeen) {
                        this.registerStatementError((PsiStatement)label, label, locationDescription);
                    }
                    return;
                }
                labelSeen = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/controlflow/DefaultNotLastCaseInSwitchInspection$DefaultNotLastCaseInSwitchVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

