/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.TestStateStorage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.FactoryMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TestFailedLineManager
implements FileEditorManagerListener {
    private final TestStateStorage myStorage;
    private final Map<VirtualFile, Map<String, TestInfo>> myMap;

    public static TestFailedLineManager getInstance(@NotNull Project project) {
        if (project == null) {
            TestFailedLineManager.$$$reportNull$$$0(0);
        }
        return (TestFailedLineManager)ServiceManager.getService((Project)project, TestFailedLineManager.class);
    }

    public TestFailedLineManager(Project project, TestStateStorage storage) {
        this.myStorage = storage;
        this.myMap = FactoryMap.create(o -> new HashMap());
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
    }

    public TestInfo getTestInfo(@NotNull PsiMethod psiMethod) {
        PsiClass psiClass;
        if (psiMethod == null) {
            TestFailedLineManager.$$$reportNull$$$0(1);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class)) == null) {
            return null;
        }
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (framework == null || !framework.isTestMethod((PsiElement)psiMethod, false)) {
            return null;
        }
        String url = "java:test://" + ClassUtil.getJVMClassName((PsiClass)psiClass) + "/" + psiMethod.getName();
        TestStateStorage.Record state = this.myStorage.getState(url);
        if (state == null) {
            return new TestInfo(null);
        }
        VirtualFile file = psiMethod.getContainingFile().getVirtualFile();
        Map<String, TestInfo> map2 = this.myMap.get(file);
        TestInfo info = map2.get(url);
        if (info == null || !state.date.equals(info.myRecord.date)) {
            info = new TestInfo(state);
            map2.put(url, info);
        }
        return info;
    }

    public TestStateStorage.Record getFailedLineState(PsiMethodCallExpression call) {
        PsiElement element;
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
        if (psiMethod == null) {
            return null;
        }
        TestInfo info = this.getTestInfo(psiMethod);
        if (info == null || info.myRecord == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)call.getProject()).getDocument(call.getContainingFile());
        if (document == null) {
            return null;
        }
        if (info.myPointer != null && (element = info.myPointer.getElement()) != null) {
            if (call == element) {
                info.myRecord.failedLine = document.getLineNumber(call.getTextOffset()) + 1;
                return info.myRecord;
            }
            return null;
        }
        TestStateStorage.Record state = info.myRecord;
        if (state.failedLine == -1 || StringUtil.isEmpty((String)state.failedMethod)) {
            return null;
        }
        if (!state.failedMethod.equals(call.getMethodExpression().getText())) {
            return null;
        }
        if (state.failedLine != document.getLineNumber(call.getTextOffset()) + 1) {
            return null;
        }
        info.myPointer = SmartPointerManager.createPointer((PsiElement)call);
        return info.myRecord;
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Map<String, TestInfo> map2;
        if (source == null) {
            TestFailedLineManager.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TestFailedLineManager.$$$reportNull$$$0(3);
        }
        if ((map2 = this.myMap.remove(file)) != null) {
            map2.forEach((s, info) -> this.myStorage.writeState(s, info.myRecord));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testIntegration/TestFailedLineManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TestInfo {
        public TestStateStorage.Record myRecord;
        public SmartPsiElementPointer<PsiElement> myPointer;

        public TestInfo(TestStateStorage.Record record) {
            this.myRecord = record;
        }
    }
}

