/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class MoveInstanceMethodDialogBase
extends MoveDialogBase {
    protected final PsiMethod myMethod;
    protected final Object[] myVariables;
    protected JList myList;
    protected JavaVisibilityPanel myVisibilityPanel;
    protected final String myRefactoringName;

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    public MoveInstanceMethodDialogBase(PsiMethod method, Object[] variables, String refactoringName) {
        super(method.getProject(), true);
        this.myMethod = method;
        this.myVariables = variables;
        this.myRefactoringName = refactoringName;
        this.setTitle(this.myRefactoringName);
    }

    protected JPanel createListAndVisibilityPanels() {
        this.myList = this.createTargetVariableChooser();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myList);
        JPanel hBox = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridheight = 1;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.insets = JBUI.emptyInsets();
        hBox.add((Component)scrollPane, gbConstraints);
        hBox.add(Box.createHorizontalStrut(4));
        gbConstraints.weightx = 0.0;
        gbConstraints.fill = 0;
        gbConstraints.anchor = 11;
        ++gbConstraints.gridx;
        this.myVisibilityPanel = MoveInstanceMethodDialogBase.createVisibilityPanel();
        hBox.add((Component)((Object)this.myVisibilityPanel), gbConstraints);
        return hBox;
    }

    protected JList createTargetVariableChooser() {
        JBList list = new JBList((ListModel)new MyListModel());
        list.setCellRenderer(new MyListCellRenderer());
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MoveInstanceMethodDialogBase.this.updateOnChanged(this.val$list);
            }
        });
        return list;
    }

    protected void updateOnChanged(JList list) {
        this.getOKAction().setEnabled(!list.getSelectionModel().isSelectionEmpty());
    }

    protected static JavaVisibilityPanel createVisibilityPanel() {
        JavaVisibilityPanel visibilityPanel = new JavaVisibilityPanel(false, true);
        visibilityPanel.setVisibility(null);
        return visibilityPanel;
    }

    protected boolean verifyTargetClass(PsiClass targetClass) {
        if (targetClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)targetClass)) {
            Project project = this.getProject();
            if (ClassInheritorsSearch.search((PsiClass)targetClass, (boolean)false).findFirst() == null) {
                String message2 = RefactoringBundle.message((String)"0.is.an.interface.that.has.no.implementing.classes", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)targetClass)});
                Messages.showErrorDialog((Project)project, (String)message2, (String)this.myRefactoringName);
                return false;
            }
            String message3 = RefactoringBundle.message((String)"0.is.an.interface.method.implementation.will.be.added.to.all.directly.implementing.classes", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)targetClass)});
            int result = Messages.showYesNoDialog((Project)project, (String)message3, (String)this.myRefactoringName, (Icon)Messages.getQuestionIcon());
            if (result != 0) {
                return false;
            }
        }
        return true;
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value2, index, isSelected, cellHasFocus);
            if (value2 instanceof PsiVariable) {
                PsiVariable psiVariable = (PsiVariable)value2;
                String text2 = PsiFormatUtil.formatVariable((PsiVariable)psiVariable, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                this.setIcon(psiVariable.getIcon(0));
                this.setText(text2);
            } else if (value2 instanceof String) {
                this.setText((String)value2);
            }
            return this;
        }
    }

    private class MyListModel
    extends AbstractListModel {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return MoveInstanceMethodDialogBase.this.myVariables.length;
        }

        @Override
        public Object getElementAt(int index) {
            return MoveInstanceMethodDialogBase.this.myVariables[index];
        }
    }
}

