/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.ClassMemberInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.LocalVariableInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.ParameterInExprUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static void analyzeExpression(PsiExpression expr, List<? super UsageInfo> localVars, List<? super UsageInfo> classMemberRefs, List<? super UsageInfo> params) {
        PsiElement[] children;
        if (expr instanceof PsiThisExpression || expr instanceof PsiSuperExpression) {
            classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)expr));
        } else if (expr instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)expr;
            PsiElement subj = refExpr.resolve();
            if (subj instanceof PsiParameter) {
                params.add(new ParameterInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiLocalVariable) {
                localVars.add(new LocalVariableInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiField || subj instanceof PsiMethod) {
                classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)refExpr));
            }
        }
        for (PsiElement child : children = expr.getChildren()) {
            if (!(child instanceof PsiExpression)) continue;
            Util.analyzeExpression((PsiExpression)child, localVars, classMemberRefs, params);
        }
    }

    @NotNull
    private static PsiElement getPhysical(@NotNull PsiElement expr) {
        PsiElement physicalElement;
        if (expr == null) {
            Util.$$$reportNull$$$0(0);
        }
        if ((physicalElement = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT)) != null) {
            expr = physicalElement;
        }
        PsiElement psiElement = expr;
        if (psiElement == null) {
            Util.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    public static PsiMethod getContainingMethod(PsiElement expr) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)Util.getPhysical(expr), PsiMethod.class);
    }

    public static boolean isAncestor(PsiElement ancestor, PsiElement element, boolean strict) {
        TextRange exprRange = (TextRange)ancestor.getUserData(ElementToWorkOn.EXPR_RANGE);
        if (exprRange != null) {
            return exprRange.contains(element.getTextRange());
        }
        return PsiTreeUtil.isAncestor((PsiElement)Util.getPhysical(ancestor), (PsiElement)Util.getPhysical(element), (boolean)strict);
    }

    public static boolean anyFieldsWithGettersPresent(List<? extends UsageInfo> classMemberRefs) {
        for (UsageInfo usageInfo : classMemberRefs) {
            PsiElement e;
            if (!(usageInfo.getElement() instanceof PsiReferenceExpression) || !((e = ((PsiReferenceExpression)usageInfo.getElement()).resolve()) instanceof PsiField)) continue;
            PsiField psiField = (PsiField)e;
            PsiMethod getterPrototype = GenerateMembersUtil.generateGetterPrototype(psiField);
            PsiMethod getter = psiField.getContainingClass().findMethodBySignature(getterPrototype, true);
            if (getter == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TIntArrayList findParametersToRemove(@NotNull PsiMethod method, @NotNull PsiExpression expr, @Nullable PsiExpression[] occurences) {
        PsiParameter[] parameters2;
        if (method == null) {
            Util.$$$reportNull$$$0(2);
        }
        if (expr == null) {
            Util.$$$reportNull$$$0(3);
        }
        if ((parameters2 = method.getParameterList().getParameters()).length == 0) {
            TIntArrayList tIntArrayList = new TIntArrayList();
            if (tIntArrayList == null) {
                Util.$$$reportNull$$$0(4);
            }
            return tIntArrayList;
        }
        Object[] overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        PsiMethod[] allMethods = (PsiMethod[])ArrayUtil.append((Object[])overridingMethods, (Object)method);
        final TIntHashSet suspects = new TIntHashSet();
        expr.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                int i;
                super.visitReferenceExpression(expression2);
                PsiElement resolved = expression2.resolve();
                if (resolved instanceof PsiParameter && (i = ArrayUtil.find((Object[])parameters2, (Object)resolved)) != -1) {
                    suspects.add(i);
                }
            }
        });
        TIntIterator iterator = suspects.iterator();
        while (iterator.hasNext()) {
            PsiParameter parameter2;
            PsiMethod psiMethod;
            PsiParameter[] psiParameters;
            int paramNum = iterator.next();
            PsiMethod[] psiMethodArray = allMethods;
            int n = psiMethodArray.length;
            for (int i = 0; i < n && (paramNum >= (psiParameters = (psiMethod = psiMethodArray[i]).getParameterList().getParameters()).length || ReferencesSearch.search((PsiElement)(parameter2 = psiParameters[paramNum]), (SearchScope)parameter2.getResolveScope(), (boolean)false).forEach(reference -> {
                PsiElement element = reference.getElement();
                boolean stillCanBeRemoved = false;
                if (element != null) {
                    boolean bl = stillCanBeRemoved = Util.isAncestor((PsiElement)expr, element, false) || PsiUtil.isInsideJavadocComment((PsiElement)Util.getPhysical(element));
                    if (!stillCanBeRemoved && occurences != null) {
                        for (PsiExpression occurence : occurences) {
                            if (!Util.isAncestor((PsiElement)occurence, element, false)) continue;
                            stillCanBeRemoved = true;
                            break;
                        }
                    }
                }
                if (!stillCanBeRemoved) {
                    iterator.remove();
                    return false;
                }
                return true;
            })); ++i) {
            }
        }
        TIntArrayList tIntArrayList = new TIntArrayList(suspects.toArray());
        if (tIntArrayList == null) {
            Util.$$$reportNull$$$0(5);
        }
        return tIntArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceParameter/Util";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceParameter/Util";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysical";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findParametersToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPhysical";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findParametersToRemove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

