/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodDialog;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import java.util.Collections;

class InlineMethodHandler
extends JavaInlineActionHandler {
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.method.title");

    private InlineMethodHandler() {
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiMethod && element.getNavigationElement() instanceof PsiMethod && element.getLanguage() == JavaLanguage.INSTANCE;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiElement referenceElement;
        boolean invokedOnReference;
        PsiElement refElement;
        String errorMessage;
        PsiElement refElement2;
        PsiReference reference;
        PsiMethod method = (PsiMethod)element.getNavigationElement();
        PsiCodeBlock methodBody2 = method.getBody();
        if (methodBody2 == null) {
            String message2 = method.hasModifierProperty("abstract") ? RefactoringBundle.message((String)"refactoring.cannot.be.applied.to.abstract.methods", (Object[])new Object[]{REFACTORING_NAME}) : (method.hasModifierProperty("native") ? RefactoringBundle.message((String)"refactoring.cannot.be.applied.to.native.methods", (Object[])new Object[]{REFACTORING_NAME}) : RefactoringBundle.message((String)"refactoring.cannot.be.applied.no.sources.attached", (Object[])new Object[]{REFACTORING_NAME}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
            return;
        }
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
        if (reference != null && !this.isEnabledForLanguage((refElement2 = reference.getElement()).getLanguage())) {
            String message3 = RefactoringBundle.message((String)"refactoring.is.not.supported.for.language", (Object[])new Object[]{"Inline of Java method", refElement2.getLanguage().getDisplayName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
            return;
        }
        boolean allowInlineThisOnly = false;
        if (InlineMethodProcessor.checkBadReturns(method) && !InlineUtil.allUsagesAreTailCalls(method)) {
            if (reference != null && InlineUtil.getTailCallType(reference) != InlineUtil.TailCallType.None) {
                allowInlineThisOnly = true;
            } else {
                String message4 = RefactoringBundle.message((String)"refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
                return;
            }
        }
        if (reference == null && InlineMethodHandler.checkRecursive(method)) {
            String message5 = RefactoringBundle.message((String)"refactoring.is.not.supported.for.recursive.methods", (Object[])new Object[]{REFACTORING_NAME});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message5, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
            return;
        }
        if (reference != null && (errorMessage = InlineMethodProcessor.checkUnableToInsertCodeBlock(methodBody2, reference.getElement())) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)REFACTORING_NAME, (String)"refactoring.inlineMethod");
            return;
        }
        if (method.isConstructor()) {
            if (method.isVarArgs()) {
                String message6 = RefactoringBundle.message((String)"refactoring.cannot.be.applied.to.vararg.constructors", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message6, (String)REFACTORING_NAME, (String)"refactoring.inlineConstructor");
                return;
            }
            boolean chainingConstructor = InlineUtil.isChainingConstructor(method);
            if (!chainingConstructor) {
                if (!InlineMethodHandler.isThisReference(reference)) {
                    String message7 = RefactoringBundle.message((String)"refactoring.cannot.be.applied.to.inline.non.chaining.constructors", (Object[])new Object[]{REFACTORING_NAME});
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message7, (String)REFACTORING_NAME, (String)"refactoring.inlineConstructor");
                    return;
                }
                allowInlineThisOnly = true;
            }
            if (reference != null) {
                PsiCall constructorCall;
                refElement = reference.getElement();
                PsiCall psiCall = constructorCall = refElement instanceof PsiJavaCodeReferenceElement ? RefactoringUtil.getEnclosingConstructorCall((PsiJavaCodeReferenceElement)refElement) : null;
                if (constructorCall == null || !method.equals(constructorCall.resolveMethod())) {
                    reference = null;
                }
            }
        } else if (reference != null && !method.getManager().areElementsEquivalent((PsiElement)method, reference.resolve())) {
            reference = null;
        }
        if (reference != null && PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiImportStaticStatement.class) != null) {
            reference = null;
        }
        boolean bl = invokedOnReference = reference != null;
        if (!invokedOnReference) {
            VirtualFile vFile = method.getContainingFile().getVirtualFile();
            ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(vFile));
        }
        refElement = null;
        if (reference != null && (referenceElement = reference.getElement()) instanceof PsiJavaCodeReferenceElement) {
            refElement = (PsiJavaCodeReferenceElement)referenceElement;
        }
        InlineMethodDialog dialog = new InlineMethodDialog(project, method, (PsiJavaCodeReferenceElement)refElement, editor, allowInlineThisOnly);
        dialog.show();
    }

    public static boolean checkRecursive(PsiMethod method) {
        return InlineMethodHandler.checkCalls((PsiElement)method.getBody(), method);
    }

    private static boolean checkCalls(PsiElement scope, PsiMethod method) {
        PsiMethod refMethod;
        if (scope instanceof PsiMethodCallExpression && method.equals(refMethod = (PsiMethod)((PsiMethodCallExpression)scope).getMethodExpression().resolve())) {
            return true;
        }
        if (scope instanceof PsiMethodReferenceExpression && method.equals(((PsiMethodReferenceExpression)scope).resolve())) {
            return true;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!InlineMethodHandler.checkCalls(child, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isThisReference(PsiReference reference) {
        PsiElement referenceElement;
        return reference != null && (referenceElement = reference.getElement()) instanceof PsiJavaCodeReferenceElement && referenceElement.getParent() instanceof PsiMethodCallExpression && "this".equals(((PsiJavaCodeReferenceElement)referenceElement).getReferenceName());
    }
}

