/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineFieldDialog;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class InlineConstantFieldHandler
extends JavaInlineActionHandler {
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.field.title");

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiField && StdLanguages.JAVA.equals(element.getLanguage());
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiElement resolve;
        PsiReference reference;
        PsiElement navigationElement = element.getNavigationElement();
        PsiField field = (PsiField)(navigationElement instanceof PsiField ? navigationElement : element);
        PsiExpression initializer = InlineConstantFieldHandler.getInitializer(field);
        if (initializer == null) {
            String message2 = RefactoringBundle.message((String)"no.initializer.present.for.the.field");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.inlineField");
            return;
        }
        if (field instanceof PsiEnumConstant) {
            String message3 = REFACTORING_NAME + " is not supported for enum constants";
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)"refactoring.inlineField");
            return;
        }
        if (ReferencesSearch.search((PsiElement)field, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)false).findFirst() == null) {
            String message4 = RefactoringBundle.message((String)"field.0.is.never.used", (Object[])new Object[]{field.getName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)REFACTORING_NAME, (String)"refactoring.inlineField");
            return;
        }
        if (!field.hasModifierProperty("final")) {
            Ref hasWriteUsages = new Ref((Object)false);
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)field)) {
                    PsiElement referenceElement = reference.getElement();
                    if (referenceElement instanceof PsiExpression && !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)referenceElement))) continue;
                    hasWriteUsages.set((Object)true);
                    break;
                }
            }), "Check if Inline Is Possible...", true, project)) {
                return;
            }
            if (((Boolean)hasWriteUsages.get()).booleanValue()) {
                String message5 = RefactoringBundle.message((String)"0.refactoring.is.supported.only.for.final.fields", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message5, (String)REFACTORING_NAME, (String)"refactoring.inlineField");
                return;
            }
        }
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
        if (reference != null && (resolve = reference.resolve()) != null && !field.equals(resolve.getNavigationElement())) {
            reference = null;
        }
        if (!(element instanceof PsiCompiledElement && reference != null || CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)field))) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        InlineUtil.checkChangedBeforeLastAccessConflicts((MultiMap<PsiElement, String>)conflicts, initializer, (PsiVariable)field);
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return;
        }
        PsiReferenceExpression refExpression = reference instanceof PsiReferenceExpression ? (PsiReferenceExpression)reference : null;
        InlineFieldDialog dialog = new InlineFieldDialog(project, field, refExpression);
        dialog.show();
    }

    @Nullable
    public static PsiExpression getInitializer(PsiField field) {
        PsiClass containingClass;
        if (field.hasInitializer()) {
            return field.getInitializer();
        }
        if (field.hasModifierProperty("final") && (containingClass = field.getContainingClass()) != null) {
            PsiMethod[] constructors = containingClass.getConstructors();
            ArrayList result = new ArrayList();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement[])constructors))) {
                PsiAssignmentExpression assignmentExpression;
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element)) || (assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class)) == null) continue;
                ContainerUtil.addIfNotNull(result, (Object)assignmentExpression.getRExpression());
            }
            if (result.isEmpty()) {
                return null;
            }
            PsiExpression first = (PsiExpression)result.get(0);
            for (PsiExpression expr : result) {
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr, (PsiElement)first)) continue;
                return null;
            }
            return first;
        }
        return null;
    }
}

