/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.codeInsight.daemon.impl.quickfix.ChangeClassSignatureFromUsageFix;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureProcessor;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.JavaCodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TableColumnAnimator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeClassSignatureDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(ChangeClassSignatureDialog.class);
    private static final int NAME_COLUMN = 0;
    private static final int BOUND_VALUE_COLUMN = 1;
    private static final int DEFAULT_VALUE_COLUMN = 2;
    private final List<TypeParameterInfo> myTypeParameterInfos;
    private final List<PsiTypeCodeFragment> myBoundValueTypeCodeFragments;
    private final List<PsiTypeCodeFragment> myDefaultValueTypeCodeFragments;
    private final PsiClass myClass;
    private final PsiTypeParameter[] myOriginalParameters;
    private final Project myProject;
    private final MyTableModel myTableModel;
    private JBTable myTable;
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"changeClassSignature.refactoring.name");
    private final boolean myHideDefaultValueColumn;

    public ChangeClassSignatureDialog(@NotNull PsiClass aClass, boolean hideDefaultValueColumn) {
        if (aClass == null) {
            ChangeClassSignatureDialog.$$$reportNull$$$0(0);
        }
        this(aClass, ChangeClassSignatureDialog.initTypeParameterInfos(aClass.getTypeParameters().length), hideDefaultValueColumn);
    }

    @NotNull
    private static List<ChangeClassSignatureFromUsageFix.TypeParameterInfoView> initTypeParameterInfos(int length) {
        ArrayList<ChangeClassSignatureFromUsageFix.TypeParameterInfoView> result = new ArrayList<ChangeClassSignatureFromUsageFix.TypeParameterInfoView>();
        for (int i = 0; i < length; ++i) {
            result.add(new ChangeClassSignatureFromUsageFix.TypeParameterInfoView(new TypeParameterInfo.Existing(i), null, null));
        }
        ArrayList<ChangeClassSignatureFromUsageFix.TypeParameterInfoView> arrayList = result;
        if (arrayList == null) {
            ChangeClassSignatureDialog.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public ChangeClassSignatureDialog(@NotNull PsiClass aClass, @NotNull List<? extends ChangeClassSignatureFromUsageFix.TypeParameterInfoView> parameters2, boolean hideDefaultValueColumn) {
        if (aClass == null) {
            ChangeClassSignatureDialog.$$$reportNull$$$0(2);
        }
        if (parameters2 == null) {
            ChangeClassSignatureDialog.$$$reportNull$$$0(3);
        }
        super(aClass.getProject(), true);
        this.myHideDefaultValueColumn = hideDefaultValueColumn;
        this.setTitle(REFACTORING_NAME);
        this.myClass = aClass;
        this.myProject = this.myClass.getProject();
        this.myOriginalParameters = this.myClass.getTypeParameters();
        this.myTypeParameterInfos = new ArrayList<TypeParameterInfo>(parameters2.size());
        this.myBoundValueTypeCodeFragments = new ArrayList<PsiTypeCodeFragment>(parameters2.size());
        this.myDefaultValueTypeCodeFragments = new ArrayList<PsiTypeCodeFragment>(parameters2.size());
        for (ChangeClassSignatureFromUsageFix.TypeParameterInfoView typeParameterInfoView : parameters2) {
            this.myTypeParameterInfos.add(typeParameterInfoView.getInfo());
            this.myBoundValueTypeCodeFragments.add(typeParameterInfoView.getBoundValueFragment());
            this.myDefaultValueTypeCodeFragments.add(typeParameterInfoView.getDefaultValueFragment());
        }
        this.myTableModel = new MyTableModel();
        this.init();
    }

    protected JComponent createNorthPanel() {
        return new JLabel(RefactoringBundle.message((String)"changeClassSignature.class.label.text", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)}));
    }

    protected String getHelpId() {
        return "change.class.signature.dialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected JComponent createCenterPanel() {
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.setStriped(true);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        TableColumn boundColumn = this.myTable.getColumnModel().getColumn(1);
        TableColumn valueColumn = this.myTable.getColumnModel().getColumn(2);
        Project project = this.myClass.getProject();
        nameColumn.setCellRenderer((TableCellRenderer)((Object)new MyCellRenderer()));
        nameColumn.setCellEditor((TableCellEditor)new StringTableCellEditor(project));
        boundColumn.setCellRenderer((TableCellRenderer)new CodeFragmentTableCellRenderer(project));
        boundColumn.setCellEditor((TableCellEditor)((Object)new JavaCodeFragmentTableCellEditor(project)));
        valueColumn.setCellRenderer((TableCellRenderer)new CodeFragmentTableCellRenderer(project));
        valueColumn.setCellEditor((TableCellEditor)((Object)new JavaCodeFragmentTableCellEditor(project)));
        this.myTable.setPreferredScrollableViewportSize(new Dimension(210, this.myTable.getRowHeight() * 4));
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myTable.setSurrendersFocusOnKeystroke(true);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setFocusCycleRoot(true);
        if (this.myHideDefaultValueColumn) {
            final TableColumn defaultValue = this.myTable.getColumnModel().getColumn(2);
            this.myTable.removeColumn(defaultValue);
            this.myTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == 1) {
                        ChangeClassSignatureDialog.this.myTable.getModel().removeTableModelListener(this);
                        TableColumnAnimator animator = new TableColumnAnimator((JTable)ChangeClassSignatureDialog.this.myTable);
                        animator.setStep(20);
                        animator.addColumn(defaultValue, ChangeClassSignatureDialog.this.myTable.getWidth() / 2);
                        animator.startAndDoWhenDone(() -> ChangeClassSignatureDialog.this.myTable.editCellAt(ChangeClassSignatureDialog.this.myTable.getRowCount() - 1, 0));
                        animator.start();
                    }
                }
            });
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"changeClassSignature.parameters.panel.border.title"), (JComponent)this.myTable), "North");
        panel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myTable).createPanel(), "Center");
        return panel;
    }

    protected void doAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        String message2 = this.validateAndCommitData();
        if (message2 != null) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.incorrect.data"), (String)message2, (String)"change.class.signature.dialog", (Project)this.myClass.getProject());
            return;
        }
        ChangeClassSignatureProcessor processor = new ChangeClassSignatureProcessor(this.myClass.getProject(), this.myClass, this.myTypeParameterInfos.toArray(new TypeParameterInfo[0]));
        this.invokeRefactoring(processor);
    }

    private String validateAndCommitData() {
        PsiTypeParameter[] parameters2 = this.myClass.getTypeParameters();
        HashMap<String, TypeParameterInfo> infos = new HashMap<String, TypeParameterInfo>();
        for (TypeParameterInfo info : this.myTypeParameterInfos) {
            if (info instanceof TypeParameterInfo.New && !PsiNameHelper.getInstance((Project)this.myClass.getProject()).isIdentifier(info.getName(parameters2))) {
                return RefactoringBundle.message((String)"error.wrong.name.input", (Object[])new Object[]{info.getName(parameters2)});
            }
            String newName = info.getName(parameters2);
            TypeParameterInfo existing = (TypeParameterInfo)infos.get(newName);
            if (existing != null) {
                return this.myClass.getName() + " already contains type parameter " + newName;
            }
            infos.put(newName, info);
        }
        LOG.assertTrue(this.myDefaultValueTypeCodeFragments.size() == this.myTypeParameterInfos.size());
        LOG.assertTrue(this.myBoundValueTypeCodeFragments.size() == this.myTypeParameterInfos.size());
        for (int i = 0; i < this.myDefaultValueTypeCodeFragments.size(); ++i) {
            TypeParameterInfo info;
            info = this.myTypeParameterInfos.get(i);
            if (info instanceof TypeParameterInfo.Existing) continue;
            String message2 = ChangeClassSignatureDialog.updateInfo(this.myDefaultValueTypeCodeFragments.get(i), (TypeParameterInfo.New)info, InfoUpdater.DEFAULT_VALUE);
            if (message2 != null) {
                return message2;
            }
            message2 = ChangeClassSignatureDialog.updateInfo(this.myBoundValueTypeCodeFragments.get(i), (TypeParameterInfo.New)info, InfoUpdater.BOUND_VALUE);
            if (message2 == null) continue;
            return message2;
        }
        return null;
    }

    private static String updateInfo(PsiTypeCodeFragment source, TypeParameterInfo.New info, InfoUpdater updater) {
        PsiType valueType;
        try {
            valueType = source.getType();
            if (valueType instanceof PsiPrimitiveType) {
                return "Type parameter can't be primitive";
            }
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e) {
            return RefactoringBundle.message((String)"changeClassSignature.bad.value", (Object[])new Object[]{updater.getValueName(), source.getText(), info.getName(null)});
        }
        catch (PsiTypeCodeFragment.NoTypeException e) {
            return updater == InfoUpdater.DEFAULT_VALUE ? RefactoringBundle.message((String)"changeSignature.no.type.for.parameter", (Object[])new Object[]{"default value", info.getName(null)}) : null;
        }
        updater.updateInfo(info, valueType);
        return null;
    }

    public static PsiTypeCodeFragment createTableCodeFragment(@Nullable PsiClassType type2, @NotNull PsiElement context, @NotNull JavaCodeFragmentFactory factory, boolean allowConjunctions) {
        if (context == null) {
            ChangeClassSignatureDialog.$$$reportNull$$$0(4);
        }
        if (factory == null) {
            ChangeClassSignatureDialog.$$$reportNull$$$0(5);
        }
        return factory.createTypeCodeFragment(type2 == null ? "" : type2.getCanonicalText(), context, true, allowConjunctions && PsiUtil.isLanguageLevel8OrHigher((PsiElement)context) ? 8 : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeClassSignature/ChangeClassSignatureDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initTypeParameterInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTableCodeFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface InfoUpdater {
        public static final InfoUpdater DEFAULT_VALUE = new InfoUpdater(){

            @Override
            public void updateInfo(TypeParameterInfo.New info, PsiType type2) {
                info.setDefaultValue(type2);
            }

            @Override
            public String getValueName() {
                return "default";
            }
        };
        public static final InfoUpdater BOUND_VALUE = new InfoUpdater(){

            @Override
            public void updateInfo(TypeParameterInfo.New info, PsiType type2) {
                info.setBoundValue(type2);
            }

            @Override
            public String getValueName() {
                return "bound";
            }
        };

        public void updateInfo(TypeParameterInfo.New var1, PsiType var2);

        public String getValueName();
    }

    private static class MyCellRenderer
    extends ColoredTableCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value2 == null) {
                return;
            }
            this.setPaintFocusBorder(false);
            this.acquireState(table, isSelected, false, row, col);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.append((String)value2);
        }
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ChangeClassSignatureDialog.this.myTypeParameterInfos.size();
        }

        @Nullable
        public Class getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((TypeParameterInfo)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex)).getName(ChangeClassSignatureDialog.this.myOriginalParameters);
                }
                case 1: {
                    return ChangeClassSignatureDialog.this.myBoundValueTypeCodeFragments.get(rowIndex);
                }
                case 2: {
                    return ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments.get(rowIndex);
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex) instanceof TypeParameterInfo.New;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return RefactoringBundle.message((String)"column.name.name");
                }
                case 1: {
                    return RefactoringBundle.message((String)"changeSignature.bound.value.column");
                }
                case 2: {
                    return RefactoringBundle.message((String)"changeSignature.default.value.column");
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((TypeParameterInfo.New)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex)).setNewName((String)aValue);
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    LOG.assertTrue(false);
                }
            }
        }

        public void addRow() {
            TableUtil.stopEditing((JTable)ChangeClassSignatureDialog.this.myTable);
            ChangeClassSignatureDialog.this.myTypeParameterInfos.add(new TypeParameterInfo.New("", null, null));
            JavaCodeFragmentFactory codeFragmentFactory = JavaCodeFragmentFactory.getInstance((Project)ChangeClassSignatureDialog.this.myProject);
            PsiClass context = ChangeClassSignatureDialog.this.myClass.getLBrace() != null ? ChangeClassSignatureDialog.this.myClass.getLBrace() : ChangeClassSignatureDialog.this.myClass;
            ChangeClassSignatureDialog.this.myBoundValueTypeCodeFragments.add(ChangeClassSignatureDialog.createTableCodeFragment(null, (PsiElement)context, codeFragmentFactory, true));
            ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments.add(ChangeClassSignatureDialog.createTableCodeFragment(null, (PsiElement)context, codeFragmentFactory, false));
            int row = ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        public void removeRow(int index) {
            ChangeClassSignatureDialog.this.myTypeParameterInfos.remove(index);
            ChangeClassSignatureDialog.this.myBoundValueTypeCodeFragments.remove(index);
            ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments.remove(index);
            this.fireTableDataChanged();
        }

        public void exchangeRows(int index1, int index2) {
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myTypeParameterInfos, (int)index1, (int)index2);
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myBoundValueTypeCodeFragments, (int)index1, (int)index2);
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments, (int)index1, (int)index2);
            this.fireTableDataChanged();
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }
    }
}

