/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PackagePrefixFileSystemItem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PackagePrefixFileSystemItemImpl
extends PsiElementBase
implements PsiFileSystemItem,
PackagePrefixFileSystemItem {
    @NotNull
    private final PsiDirectory myDirectory;
    private final int myIndex;
    private final PsiPackage[] myPackages;

    public static PackagePrefixFileSystemItemImpl create(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(0);
        }
        ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
        for (PsiPackage cur = JavaDirectoryService.getInstance().getPackage(directory); cur != null; cur = cur.getParentPackage()) {
            packages.add(0, cur);
        }
        return new PackagePrefixFileSystemItemImpl(directory, 0, packages.toArray(PsiPackage.EMPTY_ARRAY));
    }

    private PackagePrefixFileSystemItemImpl(@NotNull PsiDirectory directory, int index, PsiPackage[] packages) {
        if (directory == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(1);
        }
        this.myDirectory = directory;
        this.myIndex = index;
        this.myPackages = packages;
    }

    @NotNull
    public String getName() {
        String string = StringUtil.notNullize((String)this.myPackages[this.myIndex].getName());
        if (string == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(3);
        }
        throw new IncorrectOperationException();
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public boolean isDirectory() {
        return true;
    }

    public PsiFileSystemItem getParent() {
        return this.myIndex > 0 ? new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex - 1, this.myPackages) : this.myDirectory.getParent();
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return null;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return 0;
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return 0;
    }

    @NonNls
    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(4);
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull @NonNls CharSequence text2) {
        if (text2 == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(5);
        }
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(6);
        }
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(7);
        }
    }

    public PsiElement copy() {
        return null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(8);
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(9);
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(12);
        }
        throw new IncorrectOperationException();
    }

    public boolean isValid() {
        return this.myDirectory.isValid();
    }

    public boolean isWritable() {
        VirtualFile file = this.getVirtualFile();
        return file != null && file.isWritable();
    }

    public boolean isPhysical() {
        VirtualFile file = this.getVirtualFile();
        return file != null && !(file.getFileSystem() instanceof NonPhysicalFileSystem);
    }

    @Nullable
    public ASTNode getNode() {
        return null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        if (this.myIndex == this.myPackages.length - 1) {
            return this.myDirectory.processChildren(processor);
        }
        return processor.execute((PsiElement)new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex + 1, this.myPackages));
    }

    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(13);
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myDirectory.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        if (this.myIndex == this.myPackages.length - 1) {
            psiElementArray = this.myDirectory.getChildren();
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex + 1, this.myPackages);
        }
        if (psiElementArray == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(14);
        }
        return psiElementArray;
    }

    public boolean canNavigate() {
        return this.getVirtualFile() != null;
    }

    public VirtualFile getVirtualFile() {
        if (this.myIndex == this.myPackages.length - 1) {
            return this.myDirectory.getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.myDirectory.getIcon(flags);
    }

    @NotNull
    public PsiDirectory getDirectory() {
        PsiDirectory psiDirectory = this.myDirectory;
        if (psiDirectory == null) {
            PackagePrefixFileSystemItemImpl.$$$reportNull$$$0(15);
        }
        return psiDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

