/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.Domination;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassResolverProcessor
implements PsiScopeProcessor,
NameHint,
ElementClassHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.ClassResolverProcessor");
    private static final String[] DEFAULT_PACKAGES = new String[]{"java.lang"};
    private final String myClassName;
    @NotNull
    private final PsiFile myContainingFile;
    private final PsiElement myPlace;
    private final PsiResolveHelper myResolveHelper;
    private PsiClass myAccessClass;
    private List<ClassCandidateInfo> myCandidates;
    private boolean myHasAccessibleCandidate;
    private boolean myHasInaccessibleCandidate;
    private JavaResolveResult[] myResult;
    private PsiElement myCurrentFileContext;

    public ClassResolverProcessor(@NotNull String className, @NotNull PsiElement startPlace, @NotNull PsiFile containingFile) {
        PsiElement place;
        if (className == null) {
            ClassResolverProcessor.$$$reportNull$$$0(0);
        }
        if (startPlace == null) {
            ClassResolverProcessor.$$$reportNull$$$0(1);
        }
        if (containingFile == null) {
            ClassResolverProcessor.$$$reportNull$$$0(2);
        }
        this.myResult = JavaResolveResult.EMPTY_ARRAY;
        this.myClassName = className;
        this.myContainingFile = containingFile;
        this.myPlace = place = containingFile instanceof JavaCodeFragment && ((JavaCodeFragment)containingFile).getVisibilityChecker() != null ? null : startPlace;
        if (place instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement expression2 = (PsiJavaCodeReferenceElement)place;
            PsiElement qualifierExpression2 = expression2.getQualifier();
            if (qualifierExpression2 instanceof PsiExpression) {
                PsiType type2 = ((PsiExpression)qualifierExpression2).getType();
                if (type2 instanceof PsiClassType) {
                    this.myAccessClass = ((PsiClassType)type2).resolve();
                }
            } else if (qualifierExpression2 instanceof PsiJavaCodeReferenceElement) {
                LOG.assertTrue(qualifierExpression2.isValid());
                PsiElement resolve = ((PsiJavaCodeReferenceElement)qualifierExpression2).resolve();
                if (resolve instanceof PsiClass) {
                    this.myAccessClass = (PsiClass)resolve;
                }
            }
        }
        this.myResolveHelper = JavaPsiFacade.getInstance((Project)containingFile.getProject()).getResolveHelper();
    }

    @NotNull
    public JavaResolveResult[] getResult() {
        if (this.myResult != null) {
            if (this.myResult == null) {
                ClassResolverProcessor.$$$reportNull$$$0(3);
            }
            return this.myResult;
        }
        if (this.myCandidates == null) {
            this.myResult = JavaResolveResult.EMPTY_ARRAY;
            JavaResolveResult[] javaResolveResultArray = this.myResult;
            if (javaResolveResultArray == null) {
                ClassResolverProcessor.$$$reportNull$$$0(4);
            }
            return javaResolveResultArray;
        }
        if (this.myHasAccessibleCandidate && this.myHasInaccessibleCandidate) {
            Iterator<ClassCandidateInfo> iterator = this.myCandidates.iterator();
            while (iterator.hasNext()) {
                CandidateInfo info = (CandidateInfo)iterator.next();
                if (info.isAccessible()) continue;
                iterator.remove();
            }
            this.myHasInaccessibleCandidate = false;
        }
        this.myResult = this.myCandidates.toArray(JavaResolveResult.EMPTY_ARRAY);
        if (this.myResult == null) {
            ClassResolverProcessor.$$$reportNull$$$0(5);
        }
        return this.myResult;
    }

    @Override
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            ClassResolverProcessor.$$$reportNull$$$0(6);
        }
        return this.myClassName;
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind2) {
        if (kind2 == null) {
            ClassResolverProcessor.$$$reportNull$$$0(7);
        }
        return kind2 == ElementClassHint.DeclarationKind.CLASS;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            ClassResolverProcessor.$$$reportNull$$$0(8);
        }
        if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    private static boolean isImported(PsiElement fileContext) {
        return fileContext instanceof PsiImportStatementBase;
    }

    private boolean isOnDemand(PsiElement fileContext, PsiClass psiClass) {
        if (ClassResolverProcessor.isImported(fileContext)) {
            return ((PsiImportStatementBase)fileContext).isOnDemand();
        }
        String fqn = psiClass.getQualifiedName();
        if (fqn == null) {
            return false;
        }
        PsiFile file = this.myPlace == null ? null : FileContextUtil.getContextFile((PsiElement)this.myContainingFile);
        String[] defaultPackages = file instanceof PsiJavaFile ? ((PsiJavaFile)file).getImplicitlyImportedPackages() : DEFAULT_PACKAGES;
        String packageName = StringUtil.getPackageName((String)fqn);
        for (String defaultPackage : defaultPackages) {
            if (!defaultPackage.equals(packageName)) continue;
            return true;
        }
        return file instanceof PsiJavaFile && ((PsiJavaFile)file).getPackageName().equals(packageName);
    }

    private Domination dominates(@NotNull PsiClass aClass, boolean accessible, @NotNull String fqName, @NotNull ClassCandidateInfo info) {
        boolean otherDefault;
        boolean infoAccessible;
        PsiClass otherClass;
        String otherQName;
        if (aClass == null) {
            ClassResolverProcessor.$$$reportNull$$$0(9);
        }
        if (fqName == null) {
            ClassResolverProcessor.$$$reportNull$$$0(10);
        }
        if (info == null) {
            ClassResolverProcessor.$$$reportNull$$$0(11);
        }
        if (fqName.equals(otherQName = (otherClass = info.getElement()).getQualifiedName())) {
            return Domination.DOMINATED_BY;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = otherClass.getContainingClass();
        if (this.myAccessClass != null && !Comparing.equal((Object)containingClass1, (Object)containingClass2)) {
            if (this.myAccessClass.equals(containingClass1)) {
                return Domination.DOMINATES;
            }
            if (this.myAccessClass.equals(containingClass2)) {
                return Domination.DOMINATED_BY;
            }
        }
        if (containingClass1 != null && containingClass2 != null && containingClass2.isInheritor(containingClass1, true) && !ClassResolverProcessor.isImported(this.myCurrentFileContext) && !this.isAmbiguousInherited(containingClass1)) {
            return Domination.DOMINATED_BY;
        }
        boolean bl = infoAccessible = info.isAccessible() && this.isAccessible(otherClass);
        if (infoAccessible && !accessible) {
            return Domination.DOMINATED_BY;
        }
        if (!infoAccessible && accessible) {
            return Domination.DOMINATES;
        }
        boolean isDefault = StringUtil.getPackageName((String)fqName).isEmpty();
        boolean bl2 = otherDefault = otherQName != null && StringUtil.getPackageName((String)otherQName).isEmpty();
        if (isDefault && !otherDefault) {
            return Domination.DOMINATED_BY;
        }
        if (!isDefault && otherDefault) {
            return Domination.DOMINATES;
        }
        boolean myOnDemand = this.isOnDemand(this.myCurrentFileContext, aClass);
        boolean otherOnDemand = this.isOnDemand(info.getCurrentFileResolveScope(), otherClass);
        if (myOnDemand && !otherOnDemand) {
            return Domination.DOMINATED_BY;
        }
        if (!myOnDemand && otherOnDemand) {
            return Domination.DOMINATES;
        }
        return Domination.EQUAL;
    }

    private boolean isAccessible(PsiClass otherClass) {
        if (otherClass.hasModifierProperty("private")) {
            PsiClass containingClass = otherClass.getContainingClass();
            PsiClass containingPlaceClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)this.myPlace, PsiClass.class, (boolean)false);
            while (containingPlaceClass != null) {
                if (containingClass == containingPlaceClass) {
                    return true;
                }
                containingPlaceClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)containingPlaceClass, (Class[])new Class[]{PsiClass.class});
            }
            return false;
        }
        return true;
    }

    private boolean isAmbiguousInherited(PsiClass containingClass1) {
        for (PsiClass psiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)this.myPlace, (Class[])new Class[]{PsiClass.class}); psiClass != null; psiClass = psiClass.getContainingClass()) {
            if (!psiClass.isInheritor(containingClass1, false)) continue;
            return true;
        }
        return false;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiClass containingPlaceClass;
        boolean accessible;
        if (element == null) {
            ClassResolverProcessor.$$$reportNull$$$0(12);
        }
        if (state == null) {
            ClassResolverProcessor.$$$reportNull$$$0(13);
        }
        if (!(element instanceof PsiClass)) {
            return true;
        }
        PsiClass aClass = (PsiClass)element;
        String name = aClass.getName();
        if (!this.myClassName.equals(name)) {
            return true;
        }
        boolean bl = accessible = this.myPlace == null || this.checkAccessibility(aClass);
        if (this.myCandidates == null) {
            this.myCandidates = new SmartList();
        } else {
            String fqName = aClass.getQualifiedName();
            if (fqName != null) {
                for (int i = this.myCandidates.size() - 1; i >= 0; --i) {
                    ClassCandidateInfo info;
                    Domination domination = this.dominates(aClass, accessible && this.isAccessible(aClass), fqName, info = this.myCandidates.get(i));
                    if (domination == Domination.DOMINATED_BY) {
                        return true;
                    }
                    if (domination != Domination.DOMINATES) continue;
                    this.myCandidates.remove(i);
                }
            }
        }
        this.myHasAccessibleCandidate |= accessible;
        this.myHasInaccessibleCandidate |= !accessible;
        this.myCandidates.add(new ClassCandidateInfo((PsiElement)aClass, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), !accessible, this.myCurrentFileContext));
        this.myResult = null;
        if (!accessible) {
            return true;
        }
        if (aClass.hasModifierProperty("private") && (containingPlaceClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)this.myPlace, PsiClass.class, (boolean)false)) != null && !PsiTreeUtil.isAncestor((PsiElement)containingPlaceClass, (PsiElement)aClass, (boolean)false)) {
            return true;
        }
        if (this.myCurrentFileContext instanceof PsiImportStatementBase) {
            return ((PsiImportStatementBase)this.myCurrentFileContext).isOnDemand();
        }
        return false;
    }

    private boolean checkAccessibility(PsiClass aClass) {
        return this.myResolveHelper.isAccessible((PsiMember)aClass, this.myPlace, this.myAccessClass);
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            ClassResolverProcessor.$$$reportNull$$$0(14);
        }
        if (hintKey == ElementClassHint.KEY || hintKey == NameHint.KEY) {
            ClassResolverProcessor t = this;
            return (T)t;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPlace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/ClassResolverProcessor";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/ClassResolverProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

